% CS 6780. PCA homework starter code
% Ashutosh Saxena

% k is the number of dimensions that each face is projected to.
k = 15;
% You have to change the above if needed.



files = dir('*.JPG');

img_0 = imread(files(1).name);
num_examples = length(files);
X = zeros(num_examples, 100*100 );  % 100x100 image with three RGB colors

for n=1:num_examples
  img = imread( files(n).name );
  img = rgb2gray(img);
  img = imresize(img, [100, 100]);	% resize to 100x100 image
  img_vector = img(:);			% dimension is 30000 here
  X(n,:) = img_vector;
end

disp('Computing PCA now.');

[Vectors,Y,Values,mu] = pca(X',k);

% the function follows different convention, therefore take transpose
Vectors = Vectors';
Y = Y';
mu = mu';


% reconstruction error
reconstructed_data =  Y*Vectors + repmat(mu,num_examples,1);
mean_prediction = repmat(mu,num_examples,1);
reconstruction_error = norm( X - reconstructed_data, 'fro') / num_examples
baseline_error = norm( X - mean_prediction, 'fro') / num_examples

fraction_error = reconstruction_error.^2 / baseline_error.^2

expected_theory_error = 1 - sum(Values(1:k)) / sum(Values)

figure(100);

for n=1:num_examples
  reconstructed_img = reshape( reconstructed_data(n,:), [100, 100]);
  subplot(5,6,n);
  imagesc(reconstructed_img);  colormap gray;
end



