import java.util.ArrayList;
import java.util.Iterator;


public class Variable {
    
    public static final int NVALUES = 3; /* Number of values the variable can take */
    public static final float[][] cond = {
        {0.4f,  0.1f,  0.05f},
        {0.35f, 0.65f, 0.2f},
        {0.25f, 0.25f, 0.75f}}; /* Conditional distribution. cond[i][j] prob of child 
                                having value i given the parent has value j */
     
    boolean observed;          /* is the value of this variable observed? */
    int value;                 /* if observed, what is the value */
    ArrayList<Variable> child; /* Descendants */
    String name;               /* a name for the variable */
    float p[][];               /* p[i][j] = prob of i given the parent is j */  
    float outmsg[];            /* outgoing message (to parent) */
    float inmsg[];             /* incoming message (from parent) */
    float marginal[];          /* marginal distribution obtained by sumproduct */
    int argmax;                /* most probable state obtained by maxsum */
    int backpointer[];         /* backpointer array for maxsum */
    
    public Variable(String s) {
        name = s;
        child = new ArrayList<Variable>();
        outmsg = new float[NVALUES];
        inmsg  = new float[NVALUES];
        marginal = new float[NVALUES];
        backpointer = new int[NVALUES];
        p = cond;
    }

    public String getName() {
        return name;
    }

    public int getArgmax() {
        return argmax;
    }
    
    public float[] getOutMsg() {
        return outmsg;
    }
    
    public ArrayList<Variable> getChildren() {
        return child;
    }
    
    public void addChild(Variable c) {
        child.add(c);
    }
    
    public void clamp(int observedValue){
        observed = true;
        value = observedValue;
    }
    
    public void maximizeRoot(){
        argmax=backpointer[0];
    }

    public void setArgmax(int i) {
        argmax = i;
    }
    
    /* The incoming message to the root is just 
     * the prior probability distribution
     */
    public void setRootPrior() {
        p = new float[NVALUES][NVALUES];
        for(int j=0; j<NVALUES; j++){
            for(int i=0; i<NVALUES; i++){
                p[j][i] = 1.0f/NVALUES;
            }
            inmsg[j] = p[j][0];
        }
    }
    
    /* For a leaf node the message to the parent 
     * is just the probability of the observed value
     * given the value of the parent
     * For internal nodes, we multiply together
     * the messages from the children and
     * the conditional probability that the 
     * node has value j given that the parent
     * has value i. Finally we sum over all
     * possible values of the current node. 
     * */
    public void computeOutMsg(){
        //TODO: fill this in
    }

    /* For a leaf node we don't need to do 
     * anything because we are not going to
     * compute the marginal for it.
     * For internal nodes, we multiply together
     * the messages from all neighbors of v 
     * (the parent) except 'this'. We multiply
     * this product with the conditional 
     * probability that the node has value 
     * i given that v has value j. Finally 
     * we sum over all possible values of 
     * the current node. 
     * */
    public void computeInMsg(Variable v) {
        //TODO: fill this in
    }

    /* To compute a marginal we multiply 
     * together all messages that come 
     * into the node. We sum all the 
     * values in the product and normalize.
     */
    public void computeMarginal() {
        float z=0;
        if(observed){ //Marginals are computed only for observed data
            return;
        }
        for(int i=0; i<NVALUES; i++)
            marginal[i] = inmsg[i];        
        Iterator<Variable> it = child.iterator();
        while(it.hasNext()){
            float m[] = it.next().getOutMsg();
            for(int i=0; i<NVALUES; i++)
                marginal[i] *= m[i];
        }
        for(int i=0; i<NVALUES; i++)
            z+=marginal[i];
        for(int i=0; i<NVALUES; i++)
            marginal[i]/=z;
    }
    
    /* For a leaf node the max message to the parent 
     * is just the log probability of the observed 
     * given the value of the parent.
     * For internal nodes, we add together
     * the messages from the children and
     * the log conditional probability that the 
     * node has value j given that the parent
     * has value i. Finally we take the max
     * over all possible values of the 
     * current node.
     * During these computations we also compute
     * the backpointer array: backpointer[i]
     * is the value of the current node that
     * maximizes the i-th component of the 
     * message to the parent.
     */
    public void computeMaxMsg() {
        //TODO: fill this in
    }

    public void printmax() {
        if(observed)
            return;
        System.out.println(name+" "+argmax);
    }
    
    public void printmarg() {
        if(observed)
            return;
        System.out.print(name);
        for(int i=0; i<NVALUES; i++){
            System.out.print(" "+marginal[i]);
        }
        System.out.print("\n");
    }
}
