/*
 * @author Art Munson
 * @version 1.0
 */

package shotgun;

import java.io.File;
import java.util.Arrays;

class TopSampler implements ModelSampler
{
  private double percent = 1.0;

  public TopSampler(double percent)
  {
    if (percent < 0.0 || percent > 1.0) {
      throw new IllegalArgumentException("percent not in range [0,1]: percent=" + percent);
    }
    this.percent = percent;
  }

  public File[][] prescreen(File[][] modelFiles)
  {
    return modelFiles;
  }

  public Model[] postscreen(Model[] models)
  {
    // How many models do we want to keep?
    int count = (int)(models.length * percent);

    // Select the top performing models (measured on training set).
    // First, we need to sort them according to loss (hence, models at
    // beginning of array are better).
    Arrays.sort(models);

    // Copy all the models we want to use.
    Model[] subset = new Model[count];
    for (int i = 0; i < count; ++i) {
      subset[i] = models[i];
    }

    return subset;
  }
}





