/**
 * @author Art Munson
 * @version 1.0
 */

package shotgun;

/**
 * Class to encapsulate the prediction threshold.  For many metrics, a
 * threshold determines whether an instance is predicted positive or
 * negative.  The threshold should be the same for a given model,
 * regardless of which test set is used.
 *
 * This class allows Predictions objects to share a common
 * threshold. This is only needed when the threshold is determined
 * automatically per model (to optimize performance on some validation
 * data); otherwise, a global threshold can be used.
 *
 * Essentially, this is just a wrapper for a double value.  If the
 * builtin Double class allowed setting the value (outside of object
 * construction) we wouldn't need this class.
 *
 * Note: class is not public, so it can only be accessed from shotgun
 * package.
 */
class Threshold
{
  // Use a public field to simplify usage.
  // This is basically a struct with a constructor.
  public double value;

  public Threshold()
  {
    this(0.5);
  }

  public Threshold(double _value)
  {
    value = _value;
  }

  public Threshold(Threshold original)
  {
    value = original.value;
  }
}

