/**
 * <p>Title: Shotgun Project</p>
 * <p>Description: </p>
 * <p>Copyright: </p>
 * <p>Company: </p>
 * @author Alex Ksikes
 * @version 2.1
**/

package shotgun;

import java.io.*;
import java.util.StringTokenizer;

/**
 * A class encapsulating the targets of a set of examples.
**/
public class Targets
{

  private int[] trueValue;       // holds the targets of each example
  private int total_true_0;      // total number of true value 0
  private int total_true_1;      // total number of true value 1

  /**
   * Builds a set of targets given a file of label for each example.
   *
   * @param trueValues The file containing the labels.
  **/
  protected Targets(File trueValues)
  {
    try
    {
      BufferedReader bf=new BufferedReader(new FileReader(trueValues));
      int size=0;
      while (bf.readLine()!=null)
        size++;

      trueValue=new int[size];      
      bf=new BufferedReader(new FileReader(trueValues));
      for (int i=0; i<size; i++)
      {
        if ((trueValue[i]=Integer.parseInt(new StringTokenizer(bf.readLine()).nextToken()))==0)
          total_true_0++;
        else
          total_true_1++;
      }
    }
    catch (IOException e)
    {
	  System.out.println("Error : Problem with file " + trueValues.getName());
	  System.exit(-1);
    }
  }

  /**
   * Builds a set of targets given an array of labels for each example.
   *
   * @param targets The array of labels.
  **/
  protected Targets(int[] targets)
  {
    trueValue=new int[targets.length];
    for (int i=0; i<targets.length; i++)
    {
      if ((trueValue[i]=targets[i])==0)
        total_true_0++;
      else
        total_true_1++;
    }
  }

  /**
   * Returns the label of a particular example.
   *
   * @param i The index of the example.
  **/
  protected int getTrueValue(int i)
  {
    return trueValue[i];
  }
  
  /**
   * Returns the number of 0 labels.
  **/
  protected int getTotal_true_0()
  {
  	return total_true_0;
  }

  /**
   * Returns the number of 1 labels.
  **/
  public int getTotal_true_1()
  {
	return total_true_1;  	
  }

  /**
   * Returns the number of examples.
  **/
  public int getSize()
  {
    return trueValue.length;
  }
  
  public int[] getTargets()
  {
  	return trueValue;
  }
}
