/*
 * @author Art Munson
 * @version 1.0
 */

package shotgun;

import java.io.File;
import java.util.Random;

class RandomSampler implements ModelSampler
{
  private double percent = 1.0;
  private Random generator = null;

  public RandomSampler(double percent, long seed)
  {
    if (percent < 0.0 || percent > 1.0) {
      throw new IllegalArgumentException("percent not in range [0,1]: percent=" + percent);
    }

    this.percent = percent;
    generator = new Random(seed);
  }

  public File[][] prescreen(File[][] modelFiles)
  {
    // REVIEW: a smarter implementation is to randomly select a subset
    // of the files before loading the models.  This requires
    // shuffling the matrix though.
    return modelFiles;
  }

  public Model[] postscreen(Model[] models)
  {
    if (percent == 1.0)
      return models;

    // How many models do we want to keep?
    int count = (int)(models.length * percent);

    // Select subset randomly. To do this, shuffle all the models.
    for (int i = 0; i < models.length; ++i) {
      int swap = generator.nextInt(models.length - i) + i;
      Model temp= models[i];
      models[i] = models[swap];
      models[swap] = temp;
    }

    // Copy all the models we want to use.
    Model[] subset = new Model[count];
    for (int i = 0; i < count; ++i) {
      subset[i] = models[i];
    }

    return subset;
  }
}





