/*
 * @author Art Munson
 * @version 1.0
 */

package shotgun;

import java.io.File;

/*
 * Interface for a function object that reduces the set of models
 * loaded.
 */
interface ModelSampler
{
  /**
   * Selects a subset of the model files to use <em>before loading</em>
   * them.
   * @param modelFiles Matrix of model file names.  First dimension
   * used to organize them by test sets.  Implementors may assume that
   * each test set contains identical model file name lists (except
   * for the file extension that indicates the test set).  Also, the
   * targets file will not be included in the list.
   * @return A subset of the model files that are okay to load.  As
   * with the input list, the test set lists are identical in contents
   * modulo the file extension.  It is strongly recommended to verify
   * this in debug code, i.e.
   *    assert LibraryLoader.verifyFileNames(subsetFiles) == null;
   */
  public File[][] prescreen(File[][] modelFiles);

  /**
   * Select a subset of the models to use.
   * @param models The list of models available to use.
   * @return The subset of the models that should be used.
   */
  public Model[] postscreen(Model[] models);
}
