/*
 * Created on Jun 5, 2003
 */
package shotgun;

import java.io.File;
import java.io.FileFilter;

/**
 * An implementation of the FileFilter class which can filter out
 *  unnecessary models from the library.
 *
 * @author Geoff Crew
 */
public class ModelFilter implements FileFilter
{
	private String[] useStrings;
	private String[] ignoreStrings;
	private boolean useMode;

	/**
	 * Default Constructor
	 */
	public ModelFilter()
	{
		useStrings = new String[0];
		ignoreStrings = new String[0];
		useMode=false;
	}

  /**
   * Set the filter to ignore files whose names contain any of the
   * filter strings.
   * @param filterStrings The strings to filter out.
   */
  public void setIgnoreFilter(String[] filterStrings)
  {
    ignoreStrings = filterStrings;
  }

  /**
   * Set the filter to only use files whose names contain one of the
   * filter strings.
   * @param filterStrings The strings to match against.
   */
  public void setUseFilter(String[] filterStrings)
  {
    useStrings = filterStrings;
    useMode = true;
  }

  /**
   * Appends extra filter strings to ignore to existing ignore list.
   * @param filterStrings Extra strings to filter out.
   */
  public void appendIgnoreFilter(String[] filterStrings)
  {
    String[] oldIgnore = ignoreStrings;
    ignoreStrings = new String[oldIgnore.length + filterStrings.length];
    int count = 0;
    // Copy over the pre-existing filter strings.
    for (int i = 0; i < oldIgnore.length; ++i) {
      ignoreStrings[count++] = oldIgnore[i];
    }
    // Copy in the new filter strings.
    for (int i = 0; i < filterStrings.length; ++i) {
      ignoreStrings[count++] = filterStrings[i];
    }
  }

	/**
	 * Decide whether or not file is accepted (ignore has priority over use)
	 *
	 * @param pathname the abstract file
	 * @return true if file is accepted by filter and false if not */
	public boolean accept(File pathname)
	{
		for (int i=0; i<ignoreStrings.length; i++)
		{ // Don't use if it contains an ignore string
			if (pathname.getName().lastIndexOf(ignoreStrings[i])>=0)
				return false;
		}
		for (int i=0; i<useStrings.length; i++)
		{ // Use it if it contains a use string
			if (pathname.getName().lastIndexOf(useStrings[i])>=0)
				return true;
		}

		return !useMode;
	}
}
