/**
 * <p>Title: Shotgun Project</p>
 * <p>Description: </p>
 * <p>Copyright: </p>
 * <p>Company: </p>
 * @author Geoff Crew
 * @version 2.1
**/

package shotgun;

import java.util.Hashtable;

/**
 * Used to count how many times a model has been used in shotgun training.
 * 	You need to run the apply fuction to make counts permanet otherwise they are only 
 *  temporary.
 * 
 * @author Geoff Crew
 */
public class ModelCounts
{
	private Hashtable modelCounts;			// Hash Counts FileNames
	private int total;					// A count of the total number of models
	private Hashtable tempCounts;			// A temporary counter

	/**
	 * Default constructor
	 */
	public ModelCounts()
	{
		modelCounts = new Hashtable();
		tempCounts = new Hashtable();
		total=0;
	}
	
	/**
	 * Add a new model that we will want to count for
	 * 
	 * @param filename the name of the model
	 */
	public void add(String filename)
	{
		tempCounts.put(filename,new Integer(0));
		modelCounts.put(filename,new Integer(0));
	}
	
	/**
	 * Permanently apply counts since last apply
	 */
	public void apply()
	{
		java.util.Enumeration keys = tempCounts.keys();
		while (keys.hasMoreElements())
		{
			Object Key = keys.nextElement();
			int oldValue=((Integer)modelCounts.get(Key)).intValue();
			int addValue=((Integer)tempCounts.get(Key)).intValue();
			
			// Once we have new count, reset temporary counter
			tempCounts.put(Key, new Integer(0));
			
			total+=addValue;
			modelCounts.put(Key,new Integer(oldValue+addValue));
		}
	}
	
	/**
	 * Increment the count for the given model
	 * 
	 * @param Key the counter to be incremented
	 */
	public void increment(String Key)
	{
		try
		{
			tempCounts.put(Key, new Integer(((Integer)tempCounts.get(Key)).intValue()+1));
		}
		catch (NullPointerException e) 
		{
			add(Key);
			increment(Key);
		}
		total++;
	}
	
	/**
	 * Decrement the count for the given model
	 * 
	 * @param Key the counter to be decremented
	 */
	public void decrement(String Key)
	{
		if (Key!=null)
			tempCounts.put(Key, new Integer(((Integer)tempCounts.get(Key)).intValue()-1));
		total--;
	}
	
	/**
	 * Return the weight for a model
	 * 
	 * @param filename the name of the model you wish to retrieve a weight for
	 * @return the weight of the given model
	 */
	public double getWeight(String filename)
	{
		Integer count;
		if ((count=(Integer)modelCounts.get(filename))==null)
			return -1;
		else
			return ((double)count.intValue())/(double)total;
	}
	
	/**
	 * Return the count for a model
	 * 
	 * @param filename the name of the model you wish to retrieve a count for
	 * @return the count of the given model or -1 if that model isn't in this count
	 */
	public int getCount(String filename)
	{
		Integer count;
		if ((count=(Integer)modelCounts.get(filename))==null)
			return -1;
		else
			return count.intValue();
	}
}
