/**
 * <p>Title: Shotgun Project</p>
 * <p>Description: Confusion matrix data structure.</p>
 * @author M. Arthur Munson
 * @version 1.0
 * History:
 *  2005/02/23  Art Munson created.
 */

package shotgun;


/**
 * Encapsulation of a confusion matrix for a binary classification
 * problem.
 */
public class CMatrix
{
  // These are public for ease of use.  This is really just a
  // glorified struct anyways.  We may later want to hide these and
  // use accessors.
  public int truePos = 0;   // aka "a"
  public int falsePos = 0;  // aka "c"
  public int falseNeg = 0;  // aka "b"
  public int trueNeg = 0;   // aka "d"

  public CMatrix()
  { }

  public void tally(boolean pred, boolean truth)
  {
    if (pred) {
      if (truth) {
        ++truePos;
      }
      else {
        ++falsePos;
      }
    }
    else {
      if (truth) {
        ++falseNeg;
      }
      else {
        ++trueNeg;
      }
    }
  }

  public void clear()
  {
    truePos = trueNeg = falsePos = falseNeg = 0;
  }
}
