#!/usr/bin/perl -w
#
# Renames directory and perf.* files in directory.
#
# Usage:
#  perf_rename.pl directory old-string new-string
#
# Example:
#  perf_rename.pl sar.top50 sar all

#####################
# Documentation
#####################

=head1 NAME

perf_rename.pl

=head1 SYNOPSIS

perf_rename.pl directory old-string new-string

  Options:
    -help|?         brief help message
    -man            full documentation

=head1 DESCRIPTION

Renames directory and perf.* files in that directory.  This is best understood by example.  If there is a directory named sar.top50 containing files named

  perf.sar.top50.train
  perf.sar.top50.test1
  perf.sar.top50.test2

then the command

  perf_rename.pl sar.top50 sar all

will rename the folder to all.top50.  The files in the folder will be named

  perf.all.top50.train
  perf.all.top50.test1
  perf.all.top50.test2

=cut

#####################
# Implementation
#####################

use strict;
use Getopt::Long;
use Pod::Usage;

my $help = 0;
my $man = 0;

# Parse options and print usage if there is a syntax error.
# (or if usage explicitly requested)
GetOptions("help|?" => \$help,
	   "man" => \$man)
    or pod2usage(-verbose => 0);

pod2usage(-verbose => 1) if $help;
pod2usage(-verbose => 2) if $man;

# Collect arguments.
my ($dir, $old, $new) = @ARGV;
if (!defined($dir) || !defined($old) || !defined($new)) {
    pod2usage("$0: Missing required argument.");
}

my $newDir = $dir;
$newDir =~ s/$old/$new/;

`mv $dir $newDir`;

my @contents = split(' ', `ls $newDir/*`);

for my $file (@contents) {
    my $newName = $file;
    $newName =~ s/$old/$new/;
    `mv $file $newName`;
}
