########################################################
# Metrics:
#
# Module containing metrics used in experiments and the
# settings needed to run shotgun with them.  Following
# functions are available:
#
#  enumMetrics()
#  getOptCommand()
#  getAddCommand()
#  getAllAddCommands()
#
# History:
#  2005/12/27  created by Art Munson
########################################################

package Metrics;
use strict;

# Private module data and constants.
my %METRICS = ("acc" => ["-acc", ""],
	       "all" => ["-all 0.33 0.33 0.33", ""],
	       "apr" => ["-apr", ""],
	       "bep" => ["-bep", ""],
	       "bl" => ["-custom bl",
			"-addmetrics shotgun.metrics.BalancedLoss \"\""],
	       "ca2" => ["-ca2 100", ""],
	       "fsc" => ["-fsc", ""],
	       "lft_0.25" => ["-custom lft_0.25",
			      "-addmetrics shotgun.metrics.Lift \"0.25\""],
	       "mxe" => ["-mxe", ""],
	       "rms" => ["-rms", ""],
	       "roc" => ["-roc", ""]
	       );
my $OPT = 0;
my $ADD = 1;


# enumMetrics()
# pre: true
# post: returns list of metric names
sub enumMetrics {
    return sort keys %METRICS;
}

# getOptCommand(metric)
# pre: metric is valid metric name
# post: returns the shotgun flags to optimize metric
sub getOptCommand {
    my ($key) = @_;
    return $METRICS{$key}->[$OPT];
}

# getAddCommand(metric)
# pre: metric is valid metric name
# post: returns the shotgun flags to add the metric
#   (this string may be empty)
sub getAddCommand {
    my ($key) = @_;
    return $METRICS{$key}->[$ADD];
}

# getAllAddCommands()
# pre: true
# post: returns shotgun flags needed to add all metrics
#   (this string may be empty)
sub getAllAddCommands {
    my $adds = "";
    for my $metric (enumMetrics()) {
	my $flag = getAddCommand($metric);
	$adds .= "$flag " if ($flag ne "");
    }
    return $adds;
}

1;
