#!/usr/bin/python

import sys

if len(sys.argv) != 3:
    print 'Usage: <ground truth file> <output file of VocabMatch>'
    sys.exit(0)

fquery = open(sys.argv[1])
fout = open(sys.argv[2])

ld_list = []
for line in fquery:
    words = line.split()
    ld = int(words[1])
    ld_list.append(ld)

pos = 0
num_err = 0
for line in fout:
    words = line.split()
    pred_ld = int(words[1])
    if pred_ld != ld_list[pos]:
        num_err += 1
    pos += 1

print 'Precision %d / %d : %.3f' % (pos - num_err, pos, float(pos - num_err)/pos)

fquery.close()
fout.close()
