


#ifndef _INC_PTL
#define _INC_PTL

#include "adt_strings.h"
#include "image.h"
#include "list.h"
#include "misc.h"
#include "adtGlobals.h"


typedef struct {
  float xbase, ybase, width, height;
  adtString docstring;
  bool iscolor;  
  List data;
} *PointList;

typedef unsigned char ptlElemType;

#define  PTL_POINT    ((ptlElemType) 1)
#define  PTL_LINE     ((ptlElemType) 2)
#define  PTL_ELLIPSE  ((ptlElemType) 3)
#define  PTL_FILL     ((ptlElemType) 4)

typedef struct {
  ptlElemType type;
  RGB   color;
  float weight;
  union {
    struct {
      float x, y;
    } point;
    struct {
      float x1, y1, x2, y2;
    } line;
    struct {
      float x, y, a, b;
    } ellipse;
    struct {
      float x, y;
    } fill;
  } data;
} PointListElemStruct;
typedef PointListElemStruct * PointListElem;


ADT_LINKAGE PointList      ptlLoad(char *filename);
ADT_LINKAGE PointList      ptlLoadF(FILE *fp);
ADT_LINKAGE PointListElem  ptlGetElem(PointListElem elem, bool iscolor, FILE *fp, bool *err);
ADT_LINKAGE int            ptlPutElem(PointListElem elem, bool iscolor, FILE *fp);
ADT_LINKAGE int            ptlSave(PointList ptl, char *filename);
ADT_LINKAGE int            ptlSaveF(PointList ptl, FILE *fp);
ADT_LINKAGE void          *ptlRender(PointList ptl, ImageType type, float sx, float sy, RGB bcolor,
			 bool *warn);
ADT_LINKAGE void          *ptlLoadAndRender(FILE *fp, bool iscolor, ImageType type,
				float sx, float sy, RGB bcolor, bool *warn);
ADT_LINKAGE int            ptl_RenderElem_(PointListElem elem, void *img, ImageHeader *header,
			       float sx, float sy);
ADT_LINKAGE int            ptlStartRendering(ImageType type, float sx, float sy,
				 int xbase, int ybase, int width, int height);
ADT_LINKAGE int            ptlReadHeader(FILE *fp, bool *iscolor, float *xbase, float *ybase,
			     float *width, float *height, adtString *docstring);
ADT_LINKAGE int            ptlWriteHeader(FILE *fp, bool iscolor, float xbase, float ybase,
			      float width, float height, adtString docstring);
ADT_LINKAGE void           ptlFree(PointList ptl);
ADT_LINKAGE PointList      ptlNew(bool wantcolor, float xbase, float ybase, float width,
		      float height, adtString docstring);
ADT_LINKAGE PointListElem  ptlNewElem(ptlElemType type, RGB color, float weight,
			  float x1, float y1, float x2, float y2);
ADT_LINKAGE int            ptlSetElem(PointListElem elem, ptlElemType type, RGB color,
			  float weight, float x1, float y1, float x2, float y2);
ADT_LINKAGE void           ptlFreeElem(PointListElem elem);
ADT_LINKAGE void           ptlAddElem(PointList ptl, PointListElem elem);


#define ptlNewPoint(x, y, w, c)  ptlNewElem(PTL_POINT, (c), (w), (x), (y), 0.0, 0.0)
#define ptlNewLine(x1, y1, x2, y2, w, c)  ptlNewElem(PTL_LINE, (c), (w), (x1), (y1), \
						     (x2), (y2))
#define ptlSetPoint(e, x, y, w, c)  ptlSetElem((e), PTL_POINT, (c), (w), (x), (y), \
					       0.0, 0.0)
#define ptlSetLine(e, x1, y1, x2, y2, w, c)  ptlSetElem((e), PTL_LINE, (c), (w), \
							(x1), (y1), (x2), (y2))

#ifdef IMAGE_CHECKALL
#define ptlRenderElem(e, i)  (eassert((i) != NULL), \
			      ptl_RenderElem_((e), ((void *) (i)), (i)->header))
#else
#define ptlRenderElem(e, i)  ptl_RenderElem_((e), ((void *) (i)), (i)->header)
#endif 

#ifdef PTL_CHECKALL
#define ptlIsColor(ptl)       (eassert(ptl != NULL), ((ptl)->iscolor))
#define ptlGetXBase(ptl)      (eassert(ptl != NULL), ((ptl)->xbase))
#define ptlGetYBase(ptl)      (eassert(ptl != NULL), ((ptl)->ybase))
#define ptlGetWidth(ptl)      (eassert(ptl != NULL), ((ptl)->width))
#define ptlGetHeight(ptl)     (eassert(ptl != NULL), ((ptl)->height))
#define ptlDocString(ptl)     (eassert(ptl != NULL), ((ptl)->docstring))
#define ptlGetData(ptl)       (eassert(ptl != NULL), ((ptl)->data))
#else
#define ptlIsColor(ptl)       ((ptl)->iscolor)
#define ptlGetXBase(ptl)      ((ptl)->xbase)
#define ptlGetYBase(ptl)      ((ptl)->ybase)
#define ptlGetWidth(ptl)      ((ptl)->width)
#define ptlGetHeight(ptl)     ((ptl)->height)
#define ptlDocString(ptl)     ((ptl)->docstring)
#define ptlGetData(ptl)       ((ptl)->data)
#endif 

#endif 






