/*
 *
 *	$Header: /usr/u/wjr/src/ADT/RCS/list.h,v 1.12 1993/07/26 22:15:42 wjr Exp $
 *
 * Copyright (c) 1990, 1991, 1992, 1993 Cornell University.  All Rights
 * Reserved.
 *
 * Copyright (c) 1991, 1992 Xerox Corporation.  All Rights Reserved.
 *
 * Use, reproduction and preparation of derivative works of this software is
 * permitted.  Any copy of this software or of any derivative work must
 * include both the above copyright notices of Cornell University and Xerox
 * Corporation and this paragraph.  This software is made available AS IS, and
 * XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED
 * HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 */
/*
 * list.h - header file for the list module
 */
#ifndef LIST_H
#define LIST_H

#include "adtGlobals.h"
/*
 * Types. These types are opaque. You can't see these, really...
 */
/*
 * Complain, complain: recursive types are messy in C.
 * Note that one structure has to be named, not anonymous.
 */
typedef void (*liRemHook)(void *data);

typedef struct {
    struct _ListNode *first, *last;
    liRemHook remhook;
    } *List;

struct _ListNode {
    struct _ListNode *next, *prev;
    List owner;
    void *userdata;
    };
typedef struct _ListNode *ListNode;

/*
 * Constants
 */
#define	NULLLIST	((List)NULL)
#define	NULLLISTNODE	((ListNode)NULL)

/*
 * Functions
 */
ADT_LINKAGE  List liNew(void);
ADT_LINKAGE  void liFree(List l);
ADT_LINKAGE  ListNode liFirst(List l);
ADT_LINKAGE  ListNode liNext(ListNode ln);
ADT_LINKAGE  ListNode liAdd(List l, void *userdata);
ADT_LINKAGE  void liRem(ListNode ln);
ADT_LINKAGE  ListNode liRemAndNext(ListNode ln);
ADT_LINKAGE  void *liGet(ListNode ln);
ADT_LINKAGE  ListNode liIsIn(List l, void *userdata);
ADT_LINKAGE  unsigned int liLen(List l);
ADT_LINKAGE  void liApp(List l1, List l2);
ADT_LINKAGE  liRemHook liSetRemHook(List l, liRemHook hook);

/*
 * Macros
 */
#define foreach(ln, l) for((ln) = liFirst((l)); (ln) != NULLLISTNODE; (ln) = liNext((ln)))
#define forafter(ln1, ln2) for ((ln1) = liNext(ln2); (ln1) != NULLLISTNODE; (ln1) = liNext((ln1)))

#endif
