#ifndef __IMADDITIONS_H__
#define __IMADDITIONS_H__

#include "image.h"
#include "adtGlobals.h"

/////////////////////////////////////////////////////////////////////////////
// imAdditions.cpp - Extra Primitives for the NTadt library.
//									
// 1/17/1998 wbell@cs

// Functions declared in this file:

//AnyImage imBorders(AnyImage wo, int borderSize)
//		Creates a new image identical to the input but with a border of borderSize pixels on each side
//		of the original image.

//AnyImage imCrop(AnyImage im, int topX, int topY, int bottomX, int bottomY)
//		Creates a new image that is the cropped rectangle (topX,topY) (bottomX,bottomY)
//		out of the input.

//AnyImage imCropInto(AnyImage into, AnyImage from, 
//					int top, int left, int bottom, int right,
//					int toleft, int totop)
//		Similar to imCrop, but instead of creating a new image, it puts the cropped
//		rectangle in into, at the coordinates (toleft,totop)

//AnyImage imScale(AnyImage input, int newWidth, int newHeight)
//		Creates a new image that is the input scaled to the new width and height

//AnyImage imDupInto(AnyImage into, AnyImage in)
//		Given 2 images of the same size/type, this copies the contents of in to into into

ADT_LINKAGE  AnyImage imBorders(AnyImage wo, int borderSize);
ADT_LINKAGE  AnyImage imCrop(AnyImage im, int topX, int topY, int bottomX, int bottomY);
ADT_LINKAGE  AnyImage imCropInto(AnyImage into, AnyImage from, 
											 int top, int left, int bottom, int right,
											 int toleft, int totop);
ADT_LINKAGE  AnyImage imScale(AnyImage input, int newWidth, int newHeight);

ADT_LINKAGE  AnyImage imDupInto(AnyImage into, AnyImage in);

#endif //__IMADDITIONS_H__