/*
 *
 *	$Header: /usr/u/wjr/include/RCS/dbug.h,v 1.4 1992/11/10 17:06:18 wjr Exp $
 *
 */
/*
 *
 * debug.h - the ever-useful DEBUG() macro.
 *
 */

#ifndef DEBUG_H
#define DEBUG_H

#include "adtGlobals.h"
#ifdef DBUG

/* Need stdio to output to stderr - include it to make sure */
#include <stdio.h>

#ifndef VERBLEVEL
#define	VERBLEVEL	0
#endif

#ifdef __GNUC__

#define DEBUG(s, v...)	(void)fprintf(stderr, s, ##v)

#else

#define	DEBUG(s, v)	(void)fprintf(stderr, s, v)

#endif

#define	VDEBUG(s, v, n)	if (n <= VERBLEVEL) DEBUG(s, v); else

#else

#ifdef	__GNUC__
#define	DEBUG(s, v...)
#else
#define	DEBUG(s, v)
#endif

#define	VDEBUG(s, v, n)

#endif

#endif
