#include "seq.h"

seq *
seqNew(char *file_format, int first, int step, int last) {
  seq *s;
  
  s = malloc(sizeof(seq));
  if (s == NULL)
    return NULL;

  s->file_format = malloc(strlen(file_format));
  if (s->file_format == NULL) {
    free(s);
    return NULL;
  }

  strcpy(s->file_format, file_format);
  s->cur = s->first = first;
  s->step = step;
  s->last = last;

  return s;
}

void
seqReset(seq *s) {
  s->cur = s->first;
}

AnyImage
seqNext(seq *s) {
  char file[256];

  if ((s->step > 0) && (s->cur > s->last))
    return NULL;

  if ((s->step < 0) && (s->cur < s->last))
    return NULL;

  sprintf(file, s->file_format, s->cur);
  s->cur += s->step;

  return imLoad(IMAGE_ANY, file);
}

int
seqEmpty(seq *s) {
  if (s->step > 0)
    return (s->cur > s->last);
  else
    return (s->cur < s->last);
}

void
seqFree(seq *s) {
  free(s->file_format);
  free(s);
}
