#include "draw.h"

/* draws a line segment */

void
drawLineRGB(RGBImage out, RGB color, int x1, int y1, int x2, int y2) {
  int i;
  int xrange, yrange;
  int width = imGetWidth(out);
  int height = imGetHeight(out);

#define drawPoint(im, xpos, ypos, c) if (((xpos) >= 0) && ((xpos) < width) && ((ypos) >= 0) && ((ypos) < height)) imRef((im), (xpos), (ypos)) = (color);

  xrange = ABS(x2-x1);
  yrange = ABS(y2-y1);

  if ((xrange == 0) && (yrange == 0)) {
    drawPoint(out, x1, y1, color);
    return;
  }

  if (xrange > yrange) {
    /* line is 'horizontal'
       make sure small x comes first */
    if (x2 < x1) {
      i = x1;
      x1 = x2;
      x2 = i;
      i = y1;
      y1 = y2;
      y2 = i;
    }
    /* need signed yrange */
    yrange = y2-y1;
    for (i = 0; i <= xrange; i++) {
      drawPoint(out, x1+i, y1+((i*yrange)/xrange), color);
    }
  } else {
    /* line is 'vertical'
       make sure small y comes first */
    if (y2 < y1) {
      i = x1;
      x1 = x2;
      x2 = i;
      i = y1;
      y1 = y2;
      y2 = i;
    }
    /* need signed xrange */
    xrange = x2-x1;
    for (i = 0; i <= yrange; i++) {
      drawPoint(out, x1+((i*xrange)/yrange), y1+i, color);
    }
  } 
}


void
drawLineGray(GrayImage out, uchar color, int x1, int y1, int x2, int y2) {
  int i;
  int xrange, yrange;
  int width = imGetWidth(out);
  int height = imGetHeight(out);

#define drawPoint(im, xpos, ypos, c) if (((xpos) >= 0) && ((xpos) < width) && ((ypos) >= 0) && ((ypos) < height)) imRef((im), (xpos), (ypos)) = (color);

  xrange = ABS(x2-x1);
  yrange = ABS(y2-y1);

  if ((xrange == 0) && (yrange == 0)) {
    drawPoint(out, x1, y1, color);
    return;
  }

  if (xrange > yrange) {
    /* line is 'horizontal'
       make sure small x comes first */
    if (x2 < x1) {
      i = x1;
      x1 = x2;
      x2 = i;
      i = y1;
      y1 = y2;
      y2 = i;
    }
    /* need signed yrange */
    yrange = y2-y1;
    for (i = 0; i <= xrange; i++) {
      drawPoint(out, x1+i, y1+((i*yrange)/xrange), color);
    }
  } else {
    /* line is 'vertical'
       make sure small y comes first */
    if (y2 < y1) {
      i = x1;
      x1 = x2;
      x2 = i;
      i = y1;
      y1 = y2;
      y2 = i;
    }
    /* need signed xrange */
    xrange = x2-x1;
    for (i = 0; i <= yrange; i++) {
      drawPoint(out, x1+((i*xrange)/yrange), y1+i, color);
    }
  } 
}










