
/* need to fix to work with colors, GCs */
/* show image mashes orig image data -- should have separate display data. */
/* probably use lots of keyword arguments */
/* do I need `shift'?? (it was for text drawing) */


#include "x-stuff.h"
#include "uchar-remap.h"


#include <X.h>
#include <Xlib.h>

/* X-related variables */

#define PM_WIDTH 800
#define PM_HEIGHT 500
#define LNWIDTH 1

#define GRAYS_COMPRESS   4                   /* eg use at most 1/4 the total colors */

static  Colormap cmap;
static  Display *disp;
static  Window root;
static  Visual *visual;
static  int screen;
static  XFontStruct *font_info;
static  Pixmap shift;
static  int depth;
static  unsigned int black, white;
static  GC copyGC, blackGC, whiteGC, colorGC[10];

static  uchar GrayMapUChar[256];
xColor  GrayMap[256];


static void make_GCs();


boolean xAllocateGreyColorMap(void)	     /* grab colors for greyscales */
{
  int i, j;
  Colormap tempcmap;
  XColor def;

  tempcmap = cmap;

  for (i = 0; i < 256; i += GRAYS_COMPRESS) {
    def.red = def.green = def.blue = i << 8;
    def.flags = DoRed | DoGreen | DoBlue;

    if (!XAllocColor(disp, tempcmap, &def)) {
      return FALSE;
    }

    for (j = i; j < i + GRAYS_COMPRESS; j++) {
      GrayMap[j]      = ((xColor) {def.pixel});
      GrayMapUChar[j] = (uchar) def.pixel;
    }
  }

  return TRUE;
}


xColor xAllocateColor(RGB rgb)
{
  Colormap tempcmap;
  XColor def;

  tempcmap = cmap;
  def.red   = rgb.r << 8;
  def.green = rgb.g << 8;
  def.blue  = rgb.b << 8;
  def.flags = DoRed | DoGreen | DoBlue;

  if (XAllocColor(disp, tempcmap, &def)) {
    return ((xColor) {def.pixel});
  }
  else {
    return ((xColor) {0});                   /* error */
  }
}


xColor xAllocateNamedColor(char *name)
{
  Colormap tempcmap;
  XColor screen, exact;

  tempcmap = cmap;
  if (XAllocNamedColor(disp, tempcmap, name, &screen, &exact)) {
    return ((xColor) {screen.pixel});
  }
  else {
    return ((xColor) {0});                   /* error */
  }
}


boolean xOpenDisplay()			     /* open the display */
{
  disp   = XOpenDisplay(NULL);
  screen = DefaultScreen(disp);
  cmap   = DefaultColormap(disp, screen);
  visual = DefaultVisual(disp, screen);
  root   = DefaultRootWindow(disp);
  black  = BlackPixel(disp, screen);
  white  = WhitePixel(disp, screen);
  depth  = DefaultDepth(disp, screen);

  shift  = XCreatePixmap(disp, root, PM_WIDTH, PM_HEIGHT, depth);

  make_GCs();

  font_info = XLoadQueryFont(disp, "fixed");

  XFlush(disp);

  return TRUE;
}


void xCloseDisplay()
{
  XCloseDisplay(disp);
}


void xFlushDisplay()
{
  XFlush(disp);
}


xWindow xNewWindow(char *title, int w, int h, int x, int y)
{
  Window win;                                /* how do we make X and Y work?? */

  win = XCreateSimpleWindow(disp, root, x, y, w, h, 2, black, white);

  XStoreName(disp, win, title);
  XSetIconName(disp, win, title);

  XMapRaised(disp, win);

  return ((xWindow) {(ulong) win});
}


void xClearWindow(xWindow win)
{
  XClearWindow(disp, (Window) win.window);
  XFlush(disp);
}


void xKillWindow(xWindow win)
{
  XDestroyWindow(disp, (Window) win.window);
}


void xDrawPoint(xWindow win, xPen pen, int x, int y)
{
  XDrawPoint(disp, (Window) win.window, (GC) pen.gc, x, y);
}


void xDrawLine(xWindow win, xPen pen, int x1, int y1, int x2, int y2)
{
  XDrawLine(disp, (Window) win.window, (GC) pen.gc, x1, y1, x2, y2);
}


void xDrawVector(xWindow win, xPen pen, int x, int y, int dx, int dy)
{
  int xe, ye, xt, yt, ldx, ldy;

  xe = x + dx;
  ye = y + dy;
  XDrawLine(disp, (Window) win.window, (GC) pen.gc, x, y, xe, ye);

  xt = x + 3 * dx / 4;
  yt = y + 3 * dy / 4;
  ldx = dx / 4;
  ldy = dy / 4;
  XDrawLine(disp, (Window) win.window, (GC) pen.gc, xe, ye, xt + ldy, yt - ldx);
  XDrawLine(disp, (Window) win.window, (GC) pen.gc, xe, ye, xt - ldy, yt + ldx);
}


void xDrawRectangle(xWindow win, xPen pen, int x, int y, int w, int h)
{
  XDrawRectangle(disp, (Window) win.window, (GC) pen.gc,
		 x, y, (unsigned int) w, (unsigned int) h);
}


void xDrawString(xWindow win, xPen pen, int x, int y, char *s)
{
  return ;				     /* not yet implemented */
}


xWindow xShowImage(GrayImage im, char *title, int x, int y)
{
  xWindow win = xNewWindow(title, imGetWidth(im), imGetHeight(im), x, y);

  xShowImageIn(im, win);
  return win;
}


void xShowImageIn(GrayImage im, xWindow win)
{
  if (im->header->Ximage == (void *) NULL) {
    im->header->Ximage = (void *) XCreateImage(disp, visual, depth, ZPixmap, 0,
					       imGetStore(im), imGetWidth(im),
					       imGetHeight(im), 8, 0);
  }

  ucharRemap(imGetStore(im), imGetStoreLen(im), GrayMapUChar, NULL);
  XPutImage(disp, (Window) win.window, copyGC, (XImage *) im->header->Ximage,
	    0, 0, 0, 0, imGetWidth(im), imGetHeight(im));
  XFlush(disp);
}

int xGetButton(xWindow win)
{
  XEvent event;
  long mask;
  int button = 0;
  Window w = (Window) win.window;

  mask = ButtonPressMask;
  XSelectInput(disp, w, mask);

  if (XCheckWindowEvent(disp, w, mask, &event)) {
    if (event.xany.window == w) {	     /* on my window? */
      button = event.xbutton.button;
    }
  }

  return button;
}



xPen xMakePen_(kwArgDecl(xPenKW))
{
  kwDefault(fg,    ((xColor) {black}));
  kwDefault(bg,    ((xColor) {white}));
  kwDefault(func,  xFuncCopy);
  kwDefault(width, 1);
  kwDefault(style, xStyleSolid);
  kwDefault(fill,  xFillSolid);
  xPen pen;
  GC gc;
  XGCValues gcv;
  unsigned long mask;


  /* fg, bg, func, width, fill_style, line_style */
  mask = (GCForeground | GCBackground | GCFunction |
          GCLineWidth | GCLineStyle | GCFillStyle);
    
  gcv.foreground         = fg.color;
  gcv.background         = bg.color;
  gcv.function           = func;
  gcv.line_width         = width;
  gcv.line_style         = style;
  gcv.fill_style         = fill;
  gc                     = XCreateGC(disp, root, mask, &gcv);

  pen.gc = (void *) gc;

  return pen;
}


static void make_GCs()			     /* Make a couple of simple GCs. */
{
  XGCValues gcv;
  unsigned long mask;
  Font font;
  int i;
    
  font = XLoadFont(disp, "fixed");
    
  mask = GCForeground | GCBackground | GCFunction | GCFont;
    
  gcv.foreground         = black;
  gcv.background         = white;
  gcv.function           = GXcopy;
  gcv.font               = font;
  copyGC                 = XCreateGC(disp, root, mask, &gcv);

  mask = mask | GCLineWidth | GCLineStyle | GCFillStyle;
    
  gcv.foreground         = black;
  gcv.background         = black;
  gcv.line_width         = LNWIDTH;
  gcv.line_style         = LineSolid;
  gcv.fill_style         = FillSolid;
  blackGC                = XCreateGC(disp, root, mask, &gcv);

  gcv.foreground         = white;
  gcv.background         = white;
  whiteGC                = XCreateGC(disp, root, mask, &gcv);

  for (i = 0; i < 10; i++) {
    gcv.foreground = gcv.background = i;
    colorGC[i] = XCreateGC(disp, root, mask, &gcv);
  }
}

