


#ifndef _INC_SPLITMERGE
#define _INC_SPLITMERGE


#include "vision-types.h"
#include "keyword.h"


kwDefType(SplitMergeKW, char comment;);

/* comments we can specify: */
#define SM_COMPONENT  ((char) 0x01)          /* beginning of each component */
#define SM_PASS       ((char) 0x02)          /* beginning of each pass */


extern SegmentVector splitAndMerge_(BinaryImage img, float bendSlop, float minLength,
                                    kwArgDecl(SplitMergeKW));

#define splitAndMerge(img, bs, ml, kwargs...)   \
        (kwCall(splitAndMerge_, 3, SplitMergeKW, (img), (bs), (ml), kwargs))


typedef struct {uchar left, right;} EdgeIntensities;

vecDefStructVector(EdgeIntensVector, EdgeIntensities, StdVecUserData);


/* translated to c from welg's ~welg/stereo/segment-stereo-stable.lisp */
/* (lisp function "compute-edge-intensities")                          */
/* computes the average intensity on the left and right side of each   */
/* segment in the segment vector, in a strip of the specified width    */
/* this could probably be made much faster.                            */

extern EdgeIntensVector getEdgeIntensities(GrayImage img, SegmentVector segs, int width);

#endif _INC_SPLITMERGE
