



#ifndef _INC_MATRIX_H
#define _INC_MATRIX_H


#include "image.h"
#include "vector.h"


typedef Matrix DoubleImage;
typedef Vector DoubleVector;


#define  newMatrix(w, h)        ((Matrix) imNew(IMAGE_DOUBLE, (w), (h)))
#define  freeMatrix(m)          ((void)   imFree((DoubleImage) (m)))
#define  newVector(l)           ((Vector) vecNew(VECTOR_DOUBLE, (l)))
#define  freeVector(v)          ((void)   vecFree((DoubleVector) (v)))


Matrix matrixMult(Matrix a, Matrix b, &key Matrix into);
Matrix matrixLUdcmp(Matrix a, &key Matrix into);
Vector matrixLUbksub(Matrix LU, Vector indx, Vector b, &key Vector into);
Matrix matrixInvert(Matrix a, &key Matrix into);
double matrixCondNumber(Matrix a);
double matrixNorm(Matrix a, &key int norm);

Vector vectorAdd(Vector a, Vector b, &key Vector into);
Vector vectorScale(Vector a, double scale, &key Vector into);
Vector vectorCross(Vector a, Vector  b, &key Vector into);
double vectorDot(Vector a, Vector b);
Vector vectorOffset(Vector a, double offset, &key Vector into);
Vector vectorNorm(Vector a, &key int norm);
Vector vectorApply1();
Vector vectorApply2();


#endif   
