


#ifndef _INC_CANNY_
#define _INC_CANNY_


/***********************************  CANNY  ***********************************

 Variables:
 ==========

 CannyNoiseEstimate: float

   -- After calling the Canny routine or the noise estimate routine, this
      contains the value of the noise estimate computed.

      
 CannyThreshold1, CannyThreshold2: float

   -- After calling the Canny edge routine these contain the actual thresholds
      used.


 Functions:
 ==========

 cannyEdges(FloatImage img, float thresh1, float thresh2,
            &key boolean mutate, boolean relative, boolean recompute,
                 FloatImage *dx, FloatImage *dy, FloatImage *mag, BinaryImage into)
      ==> BinaryImage

   -- Returns the Canny edges of the input FloatImage, in a newly allocated
      BinaryImage.  A NULL image is returned on error. The thresholds, THRESH1
      and THRESH2 specify the two thresholds on the gradient magnitude.  If
      CannyRelativeThreshold is true, these thresholds are scaled relative to
      the sigma of a Raleigh distribution fit to a histogram of the gradient
      magnitude values. If THRESH2 is negative, only a single threshold is used,
      THRESH1.  Thresholds of zero indicate "no thresholding".  If both
      thresholds are specified, the larger is used as the high threshold, and
      the smaller is used as the low threshold.

      If any of DX, DY, or MAG are not specified or if the value is (FloatImage *)
      NULL, the needed storage is allocated, used, and then deallocated (temporary
      storage is used).  If it is a pointer to a NULL FloatImage, the storage is
      allocated and the computed image is returned.  Otherwise, if all are pointers
      to non-NULL FloatImages, they are assumed to already contain the gradient
      information, unless RECOMPUTE is TRUE in which case the gradient is recomputed.
      Storage is allocated for the output EDGES if EDGES is not specified of if it is
      a NULL BinaryImage, otherwise the storage provided is used.  If MUTATE is true,
      the returned gradient magnitude squared is pointwise multiplied with the output
      EDGE image and square-rooted.  Finally, if RELATIVE is TRUE, the thresholds are
      scaled by an estimate of the noise in the gradient magnitude.

  
  cannyNoiseEstimate(FloatImage mag) ==> float 

   -- Given the magnidude gradient squared, histogram the values and fit them to
      a Raleigh distribution, returning sigma for the distribution.  This
      actually does a very simple hack, which is: Find the histogram bucket with
      the largest value and return its index.  The resulting noise estimate is
      returned and also stored in the variable CannyNoiseEstimate.
  
********************************************************************************/


#include <math.h>
#include "image.h"
#include "keyword.h"


extern float       CannyNoiseEstimate;
extern float       CannyThreshold1, CannyThreshold2;



kwDefType(CannyKW, boolean mutate;
                   boolean relative;
                   boolean recompute;
                   FloatImage *dx;
                   FloatImage *dy;
                   FloatImage *mag;
                   BinaryImage into;);
          
extern BinaryImage cannyEdges_(FloatImage img, float thresh1, float thresh2,
                               kwArgDecl(CannyKW));

#define cannyEdges(img, t1, t2, kwargs...)  \
        (kwCall(cannyEdges_, 3, CannyKW, (img), (t1), (t2), kwargs))

extern float       cannyNoiseEstimate(FloatImage mag);


#endif 
