

/* x-stuff.h */

#ifndef __INC_XSTUFF__
#define __INC_XSTUFF__

#include "misc.h"
#include "image.h"
#include "keyword.h"

typedef struct {ulong window;} xWindow;
typedef struct {unsigned long color;} xColor;
typedef struct {void *gc;} xPen;

#define xWHITE  0                            /* what are these for? */
#define xBLACK  1
#define xRED    3
#define xYELLOW 4
#define xLIME   5
#define xSLATE  6
#define xBLUE   7
#define xGREEN  8
#define xPURPLE 9

extern boolean  xAllocateGreyColorMap(void);
extern xColor   xAllocateColor(RGB rgb);
extern xColor   xAllocateNamedColor(char *name);
extern boolean  xOpenDisplay();
extern void     xCloseDisplay();
extern void     xFlushDisplay();
extern xWindow  xNewWindow(char *title, int w, int h, int x, int y);
extern void     xClearWindow(xWindow win);
extern void     xKillWindow(xWindow win);
extern xWindow  xShowImage(GrayImage im, char *title, int x, int y);
extern void     xShowImageIn(GrayImage im, xWindow win);
extern void     xDrawPoint(xWindow win, xPen pen, int x, int y);
extern void     xDrawLine(xWindow win, xPen pen, int x1, int y1, int x2, int y2);
extern void     xDrawVector(xWindow win, xPen pen, int x, int y, int dx, int dy);
extern void     xDrawRectangle(xWindow win, xPen pen, int x, int y, int w, int h);
extern void     xDrawString(xWindow win, xPen pen, int x, int y, char *s);
extern int      xGetButton(xWindow win);


typedef enum { xFuncClear = 0x0,
               xFuncSet   = 0xf,
               xFuncXor   = 0x6,
               xFuncAnd   = 0x1,
               xFuncCopy  = 0x3,
               xFuncOr    = 0x7 } xPenFuncs;
typedef enum { xStyleSolid = 0} xPenStyles;
typedef enum { xFillSolid  = 0} xPenFills;

kwDefType(xPenKW, xColor fg;
                  xColor bg;
                  xPenFuncs func;
                  int width;
                  xPenStyles style;
                  xPenFills fill;);

extern xPen xMakePen_(kwArgDecl(xPenKW));

#define  xMakePen(kwargs...)     (kwCall(xMakePen_, 0, xPenKW, kwargs))


extern xColor   GrayMap[256];


#endif
