

#ifndef _INC_THRESH_GREGK_
#define _INC_THRESH_GREGK_

/***********************************  THRESH  ***********************************

 Functions:
 ==========

 threshImage(AnyImage img, float thresh1, float thresh2)
      ==> BinaryImage

   -- Threshold the image, producing a binary image.  This is a two threshold
      hysteresis operation, unless the second threshold is THRESH_NONE, in which
      case it is only a single threshold operation.  Returns a NULL image on
      error.
      

 threshImageMutate(AnyImage img, float thresh1, float thresh2)
      ==> int

   -- Like above, but mutates the input image, setting to zero all elements
      which don't pass the thresholding criteria.  Returns a non-zero value
      on error.

********************************************************************************/

#include "misc.h"
#include "image.h"


#define THRESH_NONE   (FLOAT_NAN)


extern BinaryImage thresh_Image_(AnyImage img, float thresh1, float thresh2);
extern int         thresh_ImageMutate_(AnyImage img, float thresh1, float thresh2);


#define threshImage(i, t1, t2)         thresh_Image_(imAnyImage((i)), (t1), (t2))
#define threshImageMutate(i, t1, t2)   thresh_ImageMutate_(imAnyImage((i)), (t1), (t2))

#endif 
