

#ifndef _INC_SMOOTH_GREGK_
#define _INC_SMOOTH_GREGK_

/***********************************  SMOOTH  ***********************************

 Functions:
 ==========

 smoothNormalizeMask(FloatVector mask)
      ==> void

   -- Given a mask containing the right side of a mask (such as those used by
      smoothImage() or smoothImageUsingStorage()), normalize the mask
      values to sum to 1.0.

 smoothMakeGaussianMask(float sigma, float width) 
      ==> FloatVector mask

   -- Produces a gaussian mask.  WIDTH is in terms of SIGMA.

 smoothImage(AnyImage image, FloatVector mask) 
      ==> AnyImage result

   -- Convolves the image with the mask, and returns a new Image containing
      the result, or a NULL image on error.  Currently, Gray, Float, and RGB
      input images are supported, and these give Float, Float, and RGB-Float
      results, respectively.

 smoothImageUsingStorage(AnImage image, FloatVector mask,
                         AnyImage intermediate, AnyImage output)
      ==> AnyImage result

   -- Same as above, but may be given storage for the intermediate image and
      the output image.  If INTERMEDIATE is NULL, temporary storage is allocated
      and freed.  If OUTPUT is NULL, storage is allocated and returned.
      A NULL image is returned on error.

********************************************************************************/

#include "image.h"
#include "vector.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void        smoothNormalizeMask(FloatVector mask);
extern FloatVector smoothMakeGaussianMask(float sigma, float width);
extern AnyImage    smooth_Image_(AnyImage image, FloatVector mask);
extern AnyImage    smooth_ImageUsingStorage_(AnyImage image, FloatVector mask,
					     AnyImage intermediate, AnyImage output);

#define smoothImage(im, mask)     (smooth_Image_(imAnyImage((im)), (mask)))
#define smoothImageUsingStorage(im, mask, intr, out)                                   \
        (smooth_ImageUsingStorage_(imAnyImage((im)), (mask),                           \
				   imAnyImage((intr)), imAnyImage((out))))
  
#ifdef __cplusplus
}
#endif

#endif 



