/*
 * Copyright (c) 1990, 1991 Cornell University.  All Rights Reserved.
 *
 * Copyright (c) 1991 Xerox Corporation.  All Rights Reserved.
 *
 * Use, reproduction and preparation of derivative works of this software is
 * permitted.  Any copy of this software or of any derivative work must
 * include both the above copyright notices of Cornell University and Xerox
 * Corporation and this paragraph.  This software is made available AS IS, and
 * XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED
 * HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef IMCONV_H
#define IMCONV_H

#include "image.h"

#ifdef __cplusplus
extern "C" {
#endif

extern GrayImage imcLtoG(LongImage lim, long low, long high);
extern GrayImage imcLtoGAuto(LongImage lim);
extern GrayImage imcFtoG(FloatImage fim, double low, double high);
extern GrayImage imcFtoGAuto(FloatImage fim);
extern GrayImage imcDtoG(DoubleImage dim, double low, double high);
extern GrayImage imcDtoGAuto(DoubleImage dim);
extern GrayImage imcRGBtoG(RGBImage rgbim);
extern DoubleImage imcGtoD(GrayImage gim);
extern FloatImage imcGtoF(GrayImage gim);

#ifdef __cplusplus
}
#endif

#endif


