


#ifndef _INC_GRADIENT_
#define _INC_GRADIENT_


/**********************************  GRADIENT  *********************************

 Functions:
 ==========

 gradientFull(FloatImage img, FloatImage *dx, FloatImage *dy, FloatImage *mag)
     ==> int error

  -- Computes the gradient components and squared magnitude of the gradient.
     DX[x, y] and DY[x, y] give twice the x and y components of the gradient.
     MAG[x, y] gives the sum of the squares of DX[x, y] and DY[x, y].  Storage
     will be allocated for DX, DY, and MAG if they are pointers to NULL
     FloatImages; otherwise the storage provided will be used. A non-zero value
     is returned on error -- e.g. on error allocating storage or if the result
     images passed are not the same size as the input image.

 gradientX(FloatImage img, FloatImage *dx)
 gradientY(FloatImage img, FloatImage *dy)
 gradientXandY(FloatImage img, FloatImage *dx, FloatImage *dy)
 gradientMagSqrd(FloatImage img, FloatImage *mag) 
     ==> int error

  -- These simply compute a subset of what's computed above.

 gradientMag(FloatImage img, FloatImage *mag)
     ==> int error
 
  -- Same as gradientMagSqrd() but apply a square root.
  
********************************************************************************/


#include "image.h"

extern int gradientFull(FloatImage img, FloatImage *dx, FloatImage *dy, FloatImage *mag);
extern int gradientX(FloatImage img, FloatImage *dx);
extern int gradientY(FloatImage img, FloatImage *dy);
extern int gradientXandY(FloatImage img, FloatImage *dx, FloatImage *dy);
extern int gradientMagSqrd(FloatImage img, FloatImage *mag);
extern int gradientMag(FloatImage img, FloatImage *mag);


#endif

