

#ifndef _INC_GRAB_
#define _INC_GRAB_

/************************************  GRAB  ***********************************

 Functions:
 ==========

  grabConnectToVideoPix(int port)
      ==> int port

   -- Connects to the VideoPix card in a SparcStation, if necessary, and/or changes
      ports, if necessary.  If PORT is 0 and no connection has been established,
      ports 1 through 3 are tried and the first one containing a video signal is
      used.  The actual port connected to is returned.  On error, a port value of
      zero is returned.

      This routine mainly exists to allow one to pre-connect before calling the
      grabbing routine, since the initial connection takes about 5 seconds to
      establish.

      Actually, what is really slow is checking whether there is a signal on a port.
      For this reason, if you connect to a port which has previously had a signal, it
      is assumed to still have a signal.

      
  grabDisconnectVideoPix(void)
      ==> void

   -- Disconnect from the VideoPix.

   
  grabVideoPixWidth(int skipx)  ==> int width
  grabVideoPixHeight(int skipy) ==> int height

   -- Give the width and height of frames of the given downsampling factors.
   

  grabVideoPix(&key GrayImage into,
                    int downsample, int down_x, down_y,
                    int src_x, src_y,
                    int dst_x, dst_y,
                    int width, height,
                    int port)
      ==> GreyImage image

   -- Grabs a frame from the VideoPix, connecting if necessary.  Many keyword
      arguments allow the behavior to be specified exactly.

      The keyword "into" specifies a destination GrayImage.  The default value,
      (GrayImage) NULL specifies that an appropriate image should be allocated.  If
      one is allocated, it has as X and Y bases the values of "dst_x" and "dst_y",
      and the width and height of the grab requested.

      The keyword "downsample" specifies equal downsampling for both the X and Y
      axes.  The keywords "down_x" and "down_y" allow you to specify the X or Y
      downsampling separately, and take precedence over "downsamnple".  The X and Y
      downsampling ratios default to 1.  Both ratios must be greater than 0.

      The keywords "src_x" and "src_y" specify the upper-left corner of the source
      rectangle, in frame-buffer coordinates.  Both arguments default to 0.

      The keywords "dst_x" and "dst_y" specify the upper-left corner of the
      destination rectangle (in the image).  They default to the X and Y base of the
      destination image, if one is given, or 0 if no destination image was specified.
      
      The keywords "width" and "height" specify the width and height of the frame
      that is to be grabbed (the destination rectangle).   If ommitted they default
      to the width and height necessary to reach the lower-right corner of the
      frame-buffer.  Both the width and height must be greater than zero.

      The keyword "port" specifies the VideoPix port to be used (0, 1, 2), or that
      any port with a signal is OK when the value is zero.
      
      On error (connecting to the VideoPix, allocating an image, or bad args) a NULL
      image is returned.

********************************************************************************/


#include "image.h"
#include "keyword.h"

import int  grabVideoPixWidth(int down_x);
import int  grabVideoPixHeight(int down_y);
import int  grabConnectToVideoPix(int port);
import void grabDisconnectVideoPix(void);


kwDefType(VideoPixKW, int downsample;
                      int down_x, down_y;
                      int src_x, src_y;
                      int dst_x, dst_y;
                      int width, height;
                      int port;
                      GrayImage into;);
          
import GrayImage grabVideoPix_(kwArgDecl(VideoPixKW));

#define grabVideoPix(kwargs...)  (kwCall(grabVideoPix_, 0, VideoPixKW, kwargs))


#endif 
