




#ifndef _INC_BOXFILTER_
#define _INC_BOXFILTER_


/********************************  BOX-FILTER  *********************************

 Variables:
 ==========

  BoxFilterApproxSigma: float

    -- After calling the approximated Gaussian smoothing functions, this
       variable contains the actual sigma value approximated.

 Functions:
 ==========

  boxFilterFloat(FloatImage img, int a, int b, int c, int d) ==> FloatImage result

    -- Box-filter the input image and return the resulting FloatImage. "A"
       specifies the number of pixels left of the orgin the box extends, "B"
       specifies the number of pixels right of the orgin, "C"" specifies the
       number of pixels above the orgin, and "D" specifies the number of pixels
       below the orgin the box filter extends.  On error, a NULL image is
       returned. 

  boxFilterFloatUsingStorage(FloatImage img, int a, int b, int c, int d,
		             FloatImage out) ==> FloatImage result

    -- As above except the result is computed into the output FloatImage. If the
       output image is NULL, one is allocated and returned.

  boxFilterGray(GrayImage img, int a, int b, int c, int d) ==> FloatImage result
  boxFilterGrayUsingStorage(GrayImage img, int a, int b, int c, int d,
		            FloatImage out) ==> FloatImage result

    -- Same as boxFilterFloat() and boxFilterFloatUsingStorage() except that the
       input is a GrayImage.

  boxFilterGraySigma(GrayImage img, float sigma)
  boxFilterFloatSigma(FloatImage img, float sigma)
        ==> FloatImage result

    -- Use a sequence of box-filtering operations to approximate the
       convolution of the input image with a Gaussian of the specified sigma. A
       new FloatImage is allocated and returned.  On error, a NULL image is
       returned. 

  boxFilterGraySigmaUsingStorage(GrayImage img, float sigma, FloatImage out)
  boxFilterFloatSigmaUsingStorage(FloatImage img, float sigma, FloatImage out)
        ==> FloatImage result

    -- As above, except that if the output FloatImage is non-NULL, the result is
       computed into it.
  
********************************************************************************/


#include "image.h"
#include "vector.h"

#ifdef __cplusplus
extern "C" {
#endif

extern float BoxFilterApproxSigma;

extern FloatImage boxFilterFloat(FloatImage img, int a, int b, int c, int d);
extern FloatImage boxFilterFloatUsingStorage(FloatImage img, int a, int b, int c, int d,
					     FloatImage out);

extern FloatImage boxFilterGray(GrayImage img, int a, int b, int c, int d);
extern FloatImage boxFilterGrayUsingStorage(GrayImage img, int a, int b, int c, int d,
					    FloatImage out);

extern FloatImage boxFilterGraySigma(GrayImage img, float sigma);
extern FloatImage boxFilterFloatSigma(FloatImage img, float sigma);

extern FloatImage boxFilterGraySigmaUsingStorage(GrayImage img, float sigma,
						 FloatImage out);
extern FloatImage boxFilterFloatSigmaUsingStorage(FloatImage img, float sigma,
						  FloatImage out);

#ifdef __cplusplus
}
#endif

#endif 
