/*
 *
 * panic.h - declaration of panic functions.
 *
 */

#ifndef PANIC_H
#define PANIC_H

#include <assert.h>

/* These two are used for panics: internal consistency check failure */

extern volatile void _panic(char *why, char *msg, char *rcsid, int line,
			    char *file, int die);


#define panic(msg)       _panic("Panic",          (msg), rcsid, __LINE__, __FILE__, 1)
#define assertfail(msg)  _panic("Assert failure", (msg), rcsid, __LINE__, __FILE__, 1)
#define warn(msg)        _panic("Warning",        (msg), rcsid, __LINE__, __FILE__, 0)

/* assert is for internal checks. In the production version it can be
 * redefined to null, for speed. Eassert() is an expression version */

/* Commented out, mdw. It's not nice to redefine things in standard
 * header files, no matter how convenient it might seem.
 */
/* #define assert(x)       do { if (!(x)) assertfail("!(" #x ")"); } while (0)  */

#define	eassert(x)	(!(x) ? (assertfail("!(" #x ")"), 0) : 0)

#define warnif(x)       do { if ((x)) warn((#x)); } while (0) 
#define ewarnif(x)	((x) ? (warn((#x)), 0) : 0)

#endif
