


#ifndef _INC_PTL
#define _INC_PTL

#include "adt_strings.h"
#include "image.h"
#include "list.h"
#include "misc.h"


typedef struct {
  float xbase, ybase, width, height;
  adtString docstring;
  boolean iscolor;  
  List data;
} *PointList;

typedef unsigned char ptlElemType;

#define  PTL_POINT    ((ptlElemType) 1)
#define  PTL_LINE     ((ptlElemType) 2)
#define  PTL_ELLIPSE  ((ptlElemType) 3)
#define  PTL_FILL     ((ptlElemType) 4)

typedef struct {
  ptlElemType type;
  RGB   color;
  float weight;
  union {
    struct {
      float x, y;
    } point;
    struct {
      float x1, y1, x2, y2;
    } line;
    struct {
      float x, y, a, b;
    } ellipse;
    struct {
      float x, y;
    } fill;
  } data;
} *PointListElem;


PointList      ptlLoad(char *filename);
PointList      ptlLoadF(FILE *fp);
PointListElem  ptlGetElem(PointListElem elem, boolean iscolor, FILE *fp, boolean *err);
int            ptlPutElem(PointListElem elem, boolean iscolor, FILE *fp);
int            ptlSave(PointList ptl, char *filename);
int            ptlSaveF(PointList ptl, FILE *fp);
void          *ptlRender(PointList ptl, ImageType type, float sx, float sy, RGB bcolor,
			 boolean *warn);
void          *ptlLoadAndRender(FILE *fp, boolean iscolor, ImageType type,
				float sx, float sy, RGB bcolor, boolean *warn);
int            ptl_RenderElem_(PointListElem elem, void *img, ImageHeader *header,
			       float sx, float sy);
int            ptlStartRendering(ImageType type, float sx, float sy,
				 int xbase, int ybase, int width, int height);
int            ptlReadHeader(FILE *fp, boolean *iscolor, float *xbase, float *ybase,
			     float *width, float *height, adtString *docstring);
int            ptlWriteHeader(FILE *fp, boolean iscolor, float xbase, float ybase,
			      float width, float height, adtString docstring);
void           ptlFree(PointList ptl);
PointList      ptlNew(boolean wantcolor, float xbase, float ybase, float width,
		      float height, adtString docstring);
PointListElem  ptlNewElem(ptlElemType type, RGB color, float weight,
			  float x1, float y1, float x2, float y2);
int            ptlSetElem(PointListElem elem, ptlElemType type, RGB color,
			  float weight, float x1, float y1, float x2, float y2);
void           ptlFreeElem(PointListElem elem);
void           ptlAddElem(PointList ptl, PointListElem elem);


#define ptlNewPoint(x, y, w, c)  ptlNewElem(PTL_POINT, (c), (w), (x), (y), 0.0, 0.0)
#define ptlNewLine(x1, y1, x2, y2, w, c)  ptlNewElem(PTL_LINE, (c), (w), (x1), (y1), \
						     (x2), (y2))
#define ptlSetPoint(e, x, y, w, c)  ptlSetElem((e), PTL_POINT, (c), (w), (x), (y), \
					       0.0, 0.0)
#define ptlSetLine(e, x1, y1, x2, y2, w, c)  ptlSetElem((e), PTL_LINE, (c), (w), \
							(x1), (y1), (x2), (y2))

#ifdef IMAGE_CHECKALL
#define ptlRenderElem(e, i)  (eassert((i) != NULL), \
			      ptl_RenderElem_((e), ((void *) (i)), (i)->header))
#else
#define ptlRenderElem(e, i)  ptl_RenderElem_((e), ((void *) (i)), (i)->header)
#endif 

#ifdef PTL_CHECKALL
#define ptlIsColor(ptl)       (eassert(ptl != NULL), ((ptl)->iscolor))
#define ptlGetXBase(ptl)      (eassert(ptl != NULL), ((ptl)->xbase))
#define ptlGetYBase(ptl)      (eassert(ptl != NULL), ((ptl)->ybase))
#define ptlGetWidth(ptl)      (eassert(ptl != NULL), ((ptl)->width))
#define ptlGetHeight(ptl)     (eassert(ptl != NULL), ((ptl)->height))
#define ptlDocString(ptl)     (eassert(ptl != NULL), ((ptl)->docstring))
#define ptlGetData(ptl)       (eassert(ptl != NULL), ((ptl)->data))
#else
#define ptlIsColor(ptl)       ((ptl)->iscolor)
#define ptlGetXBase(ptl)      ((ptl)->xbase)
#define ptlGetYBase(ptl)      ((ptl)->ybase)
#define ptlGetWidth(ptl)      ((ptl)->width)
#define ptlGetHeight(ptl)     ((ptl)->height)
#define ptlDocString(ptl)     ((ptl)->docstring)
#define ptlGetData(ptl)       ((ptl)->data)
#endif 

#endif 






