/*
 * priq.h - header file for the priority queue module
 */
#ifndef PRIQ_H
#define PRIQ_H

/*
 * Types. These types are opaque. You can't see these, really...
 */
typedef struct {
    struct _PriQIntNode *root, *last;
    boolean (*compareGT)();
    } *PriQ;

typedef struct _PriQIntNode {
    struct _PriQIntNode *left, *right, *parent, *next, *prev;
    struct _PriQNode *owner;
    char *userdata;
    } *PriQIntNode;

typedef struct _PriQNode {
    PriQIntNode val;
    PriQ owner;
    } *PriQNode;

/*
 * Constants
 */
#define	NULLPRIQ	((PriQ)NULL)
#define	NULLPRIQNODE	((PriQNode)NULL)

/*
 * Functions
 */
extern PriQ pqNew(boolean (*compareGT)());
extern void pqFree(PriQ p);
extern PriQNode pqFirst(PriQ p);
extern PriQNode pqAdd(PriQ p, char *userdata);
extern void pqRem(PriQNode pqn);
extern char *pqGet(PriQNode pqn);

#endif
