/*
 * Copyright (c) 1990, 1991, 1992, 1993 Cornell University.  All Rights
 * Reserved.
 *
 * Copyright (c) 1991, 1992 Xerox Corporation.  All Rights Reserved.
 *
 * Use, reproduction and preparation of derivative works of this software is
 * permitted.  Any copy of this software or of any derivative work must
 * include both the above copyright notices of Cornell University and Xerox
 * Corporation and this paragraph.  This software is made available AS IS, and
 * XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED
 * HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 */
/*
 *
 * misc.h - miscellaneous types and declarations
 *
 */

#ifndef WJR_MISC_H
#define	WJR_MISC_H

/* Stuff needed for gregk */
typedef unsigned char uchar;

typedef struct {uchar r, g, b;} RGB;
typedef struct {float r, g, b;} RGBFloat;
typedef struct {float h, s, v;} HSV;
#define import         extern
#define export
#define local          static


/*
 * Stuff for C*; these are snitched from their stdlib.h.
 * I don't include their stdlib.h because it declares malloc as returning
 * char *, which conflicts with the nice definition below.
 */
#ifdef	cstar
extern void psrand(unsigned seed);
extern int:current prand(void);
extern void deallocate_shape(shape *s);
extern void:void * palloc(shape s, int bsize);
extern void pfree(void:void *pvar);

/* They don't implement volatile, so we get lots of warnings... */
#define	volatile
#endif

typedef char boolean;
#ifndef TRUE
#define TRUE	((boolean)1)
#endif
#ifndef FALSE
#define FALSE	((boolean)0)
#endif

#ifndef __GNUC__
#ifdef	cstar

/* Use the C* extensions: >? (MAX) and <? (MIN) operators */
#ifndef	MAX
#define	MAX(x, y) ((x) >? (y))
#endif

#ifndef	MIN
#define	MIN(x, y) ((x) <? (y))
#endif

#ifndef	ABS
#define	ABS(x)	((x) >? (-(x)))
#endif

#else

#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif

#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#endif

#ifndef ABS
#define ABS(x) (((x) < 0) ? -(x) : (x))
#endif

/* Added from gregk's misc.h */
#ifndef SWAP
#define SWAP(a, b)  ({ typeof (a) _tmp = (a); (a) = (b); (b) = _tmp; })
#endif

#endif

#else

/* GCC allows new scopes inside expressions; use to get better MAX and MIN */

#ifndef MAX
#define MAX(a, b)   ({ typeof (a) _a = (a); typeof (b) _b = (b); _a > _b ? _a : _b; })
#endif

#ifndef MIN
#define MIN(a, b)   ({ typeof (a) _a = (a); typeof (b) _b = (b); _a < _b ? _a : _b; })
#endif

#ifndef ABS
#define ABS(a)      ({ typeof (a) _a = (a); _a < (typeof (a)) 0 ? -_a : _a; })
#endif

#define SQUARE(x)   ({ typeof (x) _x = (x); _x*_x; })
#define CUBE(x)     ({ typeof (x) _x = (x); _x*_x*_x; })
#define SWAP(a, b)  ({ typeof (a) _tmp = (a); (a) = (b); (b) = _tmp; })
#define ROUND(a)    ({ typeof (a) __a = (a); (int) ((__a > 0) ? (__a + 0.5) : (__a - 0.5)); })
#define FLOAT_NAN     ({ float f; (*((long *) &f) = 0x7fffffff); f;})
#define DOUBLE_NAN    ({ double d; (*((long *) &d) = 0x7fffffff); (*(((long *) &d) + 1) = 0xffffffff); d;})


#endif

#define BOUND(x, l, h)   (MIN(MAX((x), (l)), (h)))

/* This is what malloc returns on error, and is also a null pointer */
#ifndef NULL
#define NULL    0
#endif

/*
 * Include common files. These come AFTER the defines above,
 * because mine are better.
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include "panic.h"
#include "dbug.h"

/* Some library routines that never seem to get declared */

/* Time stuff */
/*
extern char *strptime(char *buf, char *fmt, struct tm *tm);
extern time_t timegm(struct tm *tm);
extern time_t timelocal(struct tm *tm);
extern void tzset(void);
extern void tzsetwall(void);
*/
#endif
