/*
 * Header file for the histogram ADT
 */

#ifndef HIST_H
#define HIST_H

/* One opaque type, coming right up... */
typedef struct {
    double *bins;
    unsigned nbins;
    double low;
    double high;
    } *Histogram;

/* Exported routines */
extern Histogram hiNew(unsigned nbins, double low, double high);
extern void hiFree(Histogram h);
extern void hiAdd(Histogram h, double val, double howmuch);

/* These are routines which happen to be implemented as macros, at present. */
/*
 * Note that these do not return lvalues, but *rvalues only*. If you use
 * these to get lvalues, a pox be upon you and your offspring unto the
 * seventh generation!
 *
 * These have less error checking than is really desirable.
 */
#define hiLow(h)	((h)->low)
#define	hiHigh(h)	((h)->high)
#define hiNBins(h)	((h)->nbins)

/* This allows access to a particular bin. It would be nice if it checked... */
#define hiCount(h,n)	(((h)->bins)[n])

/* and a useful abbreviation */
#define	hiInc(h,val)	hiAdd((h), (val), 1.)

/* Some useful things to find the locations of bins */
#define	hiBinL(h,n)	((h)->low + ((h)->high - (h)->low) / (h)->nbins * (n))
#define	hiBinR(h,n)	((h)->low + ((h)->high - (h)->low) / (h)->nbins * ((n)+1))
#define	hiBinC(h,n)	((h)->low + ((h)->high - (h)->low) / (h)->nbins * ((n)+.5))

/* The constant null histogram, used as an error return from hiNew */
#define	NULLHIST	((Histogram)NULL)

#endif
