/*
 * counter.h - header file for the counter module
 */
#ifndef COUNTER_H
#define COUNTER_H

/* Need this for "boolean" */
#include "misc.h"

/*
 * Types. These types are opaque. You can't see these, really...
 */
typedef struct {
    unsigned lsw;
    unsigned msw;
    } Counter;

/*
 * Functions
 */
extern void coInit(Counter *c);
extern void coInc(Counter *c);
extern boolean coGT(Counter *c1, Counter *c2);
extern boolean coEQ(Counter *c1, Counter *c2);
extern void coCopy(Counter *d, Counter *s);

#endif
