


#ifndef __INC_ADT_STRING
#define __INC_ADT_STRING

#include "panic.h"
#include "misc.h"



typedef struct {
  char *data;
  int mxlen;
} adtStringHeader;

typedef adtStringHeader *adtString;


#define ADT_NULLSTRING       ((adtString) NULL)

typedef adtString String;
#define NULLSTRING ADT_NULLSTRING


extern adtString  strNew(int mxlen);
extern void    strFree(adtString str);
extern adtString  strClear(adtString str);
extern adtString  strNewCopy(adtString str);
extern adtString  strMake(char *s);
extern int     strLen(adtString str);
extern int     strCmp(adtString a, adtString b);
extern int     strMaxLen(adtString str);
extern char   *strGet(adtString str);
extern char    strRef(adtString str, int i);


extern adtString  strInit_(adtString *dest, char *s);
#define strInit(dest, s)          strInit_(&(dest), (s))
extern adtString  strCopy_(adtString *dest, adtString src);
#define strCopy(dest, src)        strCopy_(&(dest), (src))
extern adtString  strCat_(adtString *dest, adtString src);
#define strCat(dest, src)         strCat_(&(dest), (src))
extern adtString  strAddChar_(adtString *dest, char ch);
#define strAddChar(dest, ch)      strAddChar_(&(dest), (ch))
extern int     strNewLen_(adtString *dest, int newlen);
#define strNewLen(dest, newlen)   strNewLen_(&(dest), (newl))



/* probably need strSubStr, strInsert, find-substring,
   strToInt, strToFloat, strPrintF (using vsprintf) ... */

#endif 
