

static char rcsid[] = "@(#)$Header: /home/vi/gregk/wjr/src/support-gregk/strings.c gregk Exp $";


#include "adt_strings.h"



adtString strNew(int mxlen)
{
  adtString str;

  if (mxlen <= 0)
    mxlen = 10;
  
  if ((str = (adtString) malloc(sizeof(adtStringHeader))) == ADT_NULLSTRING)
    return ADT_NULLSTRING;

  if ((str->data = (char *) malloc(mxlen+1)) == (char *) NULL) {
    free(str);
    return ADT_NULLSTRING;
  }

  str->mxlen   = mxlen;
  str->data[0] = (char) 0;

  return str;  
}

void strFree(adtString str)
{
  if (str != ADT_NULLSTRING) {
    free(str->data);
    free(str);
  }
}

adtString strClear(adtString str)
{
  if (str != ADT_NULLSTRING) {
    str->data[0] = (char) 0;
  }

  return str;
}

adtString strInit_(adtString *dest, char *s)
{
  int slen;


  if (s == (char *) NULL)
    return strClear(*dest);
  else {
    slen = strlen(s);

    if (*dest == ADT_NULLSTRING) {
      *dest = strNew(slen);

      if (*dest == ADT_NULLSTRING)
	return ADT_NULLSTRING;
    }
    else if ((*dest)->mxlen < slen) {
      char *new = (char *) malloc(slen+1);

      if (new == (char *) NULL)
	return ADT_NULLSTRING;
    
      free((*dest)->data);
      (*dest)->data  = new;
      (*dest)->mxlen = slen;
    }

    strcpy((*dest)->data, s);
    return *dest;
  }
}

adtString strCopy_(adtString *dest, adtString src)
{
  return strInit_(dest, strGet(src));
}

adtString strNewCopy(adtString str)
{
  adtString tmp;
  
  if (str == ADT_NULLSTRING)
    return ADT_NULLSTRING;

  tmp = strNew(strLen(str));
  return strCopy(tmp, str);
}

adtString strCat_(adtString *dest, adtString src)
{
  int dlen, slen;


  slen = strLen(src);
  dlen = strLen(*dest);
  
  if (*dest == ADT_NULLSTRING) {
    *dest = strNew(slen);

    if (*dest == ADT_NULLSTRING)
      return ADT_NULLSTRING;
  }
  
  if (dlen + slen > (*dest)->mxlen  &&  strNewLen_(dest, 2*(dlen + slen)))
    return ADT_NULLSTRING;

  strcpy((*dest)->data + dlen, src->data);
  return *dest;
}

adtString strAddChar_(adtString *dest, char ch)
{
  int dlen;
  
  if (*dest == ADT_NULLSTRING) {
    *dest = strNew(20);

    if (*dest == ADT_NULLSTRING)
      return ADT_NULLSTRING;
  }

  dlen = strlen((*dest)->data);
  if (dlen >= (*dest)->mxlen  &&  strNewLen_(dest, 2*dlen))
    return ADT_NULLSTRING;

  (*dest)->data[dlen]     = ch;
  (*dest)->data[dlen + 1] = (char) 0;
  return *dest;
}

int strNewLen_(adtString *dest, int newlen)
{
  char *new;
  int dlen;

  
  if (*dest == ADT_NULLSTRING) {
    return ((*dest = strNew(newlen)) == ADT_NULLSTRING);
  }
  else {
    if ((dlen = strlen((*dest)->data)) > newlen)
      return 1;

    new = (char *) malloc(newlen + 1);

    if (new == (char *) NULL)
      return 1;

    strcpy(new, (*dest)->data);
    free((*dest)->data);
    (*dest)->data  = new;
    (*dest)->mxlen = newlen;

    return 0;
  }
}
  
adtString strMake(char *s)
{
  adtString tmp = ADT_NULLSTRING;
  
  return strInit(tmp, s);
}

int    strLen(adtString str)
{
  return (str == ADT_NULLSTRING) ? 0 : strlen(str->data);
}

int    strCmp(adtString a, adtString b)
{
  char *aa = (a == ADT_NULLSTRING) ? "" : a->data;
  char *bb = (b == ADT_NULLSTRING) ? "" : b->data;

  return strcmp(aa, bb);
}

int    strMaxLen(adtString str)
{
  return (str == ADT_NULLSTRING) ? 0 : str->mxlen;
}

char  *strGet(adtString str)
{
  return (str == ADT_NULLSTRING) ? "" : str->data;
}

char    strRef(adtString str, int i)
{
  if (str == ADT_NULLSTRING) {
    return (char) 0;
  }
  else if (i >= str->mxlen  ||  i < 0) {
    assert(0);
    return (char) 0;
  }
#ifdef STRING_CHK_REF
  else if (i >= strlen(str->data)) {
    assert(0);
    return (char) 0;
  }
#endif
  else
    return str->data[i];
}

