/*
 *
 *	$Header: /usr/u/wjr/src/ADT/RCS/priq.h,v 1.5 1993/11/04 21:33:31 wjr Exp $
 *
 */
/*
 * priq.h - header file for the priority queue module
 */
#ifndef PRIQ_H
#define PRIQ_H
#include "chunk.h"
#include "adtGlobals.h"

/*
 * Types. These types are opaque. You can't see these, really...
 */
typedef struct {
    struct _PriQIntNode *root, *last;
    bool (*compareGT)(void *a, void *b);
    unsigned count;
    } *PriQ;

typedef struct _PriQIntNode {
    struct _PriQIntNode *left, *right, *parent, *next, *prev;
    struct _PriQNode *owner;
    void *userdata;
    } *PriQIntNode;

typedef struct _PriQNode {
    PriQIntNode val;
    PriQ owner;
    } *PriQNode;

extern Chunk pqnChunk;
extern Chunk pqinChunk;


/*
 * Constants
 */
#define	NULLPRIQ	((PriQ)NULL)
#define	NULLPRIQNODE	((PriQNode)NULL)

/*
 * Functions
 */
ADT_LINKAGE PriQ pqNew(bool (*compareGT)(void *a, void *b));
ADT_LINKAGE void pqFree(PriQ p);
ADT_LINKAGE PriQNode pqFirst(PriQ p);
ADT_LINKAGE PriQNode pqAdd(PriQ p, void *userdata);
ADT_LINKAGE void pqRem(PriQNode pqn);
ADT_LINKAGE void *pqGet(PriQNode pqn);
ADT_LINKAGE unsigned int pqLen(PriQ p);

#endif
