/*
 *
 *	$Header: /amd/day/b/robotlab/new/src/lib-adt/RCS/misc.h,v 1.1 1994/06/18 00:14:13 mdw Exp mdw $
 *
 * Copyright (c) 1990, 1991, 1992, 1993 Cornell University.  All Rights
 * Reserved.
 *
 * Copyright (c) 1991, 1992 Xerox Corporation.  All Rights Reserved.
 *
 * Use, reproduction and preparation of derivative works of this software is
 * permitted.  Any copy of this software or of any derivative work must
 * include both the above copyright notices of Cornell University and Xerox
 * Corporation and this paragraph.  This software is made available AS IS, and
 * XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED
 * HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 */
/*
 *
 * misc.h - miscellaneous types and declarations
 *
 */

#ifndef WJR_MISC_H
#define	WJR_MISC_H

#include "adtGlobals.h"

/* Stuff needed for gregk */
typedef unsigned char uchar;

#ifndef SVR4
typedef unsigned long ulong;
#endif //SVR4

typedef unsigned int uint;


typedef struct {uchar r, g, b;} RGB;
typedef struct {float r, g, b;} RGBFloat;
typedef struct {float h, s, v;} HSV;
#define import         ADT_LINKAGE 
#define export
#define local          static

#ifndef max
#define max(a,b)	((a) > (b) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)	((a) < (b) ? (a) : (b))
#endif

#ifndef max3
#define max3(a,b,c)	((a) > (b) ? max((a),(c)) : max((b),(c)))
#endif

#ifndef min3
#define min3(a,b,c)	((a) < (b) ? min((a),(c)) : min((b),(c)))
#endif


/*
 * Stuff for C*; these are snitched from their stdlib.h.
 * I don't include their stdlib.h because it declares malloc as returning
 * char *, which conflicts with the nice definition below.
 */
#ifdef	cstar
ADT_LINKAGE  void psrand(unsigned seed);
ADT_LINKAGE  int:current prand(void);
ADT_LINKAGE  void deallocate_shape(shape *s);
ADT_LINKAGE  void:void * palloc(shape s, int bsize);
ADT_LINKAGE  void pfree(void:void *pvar);

/* They don't implement volatile, so we get lots of warnings... */
#define	volatile
#endif

#ifndef __GNUC__
#ifdef	cstar

/* Use the C* extensions: >? (MAX) and <? (MIN) operators */
#ifndef	MAX
#define	MAX(x, y) ((x) >? (y))
#endif

#ifndef	MIN
#define	MIN(x, y) ((x) <? (y))
#endif

#ifndef	ABS
#define	ABS(x)	((x) >? (-(x)))
#endif

#else

#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif

#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#endif

#ifndef ABS
#define ABS(x) (((x) < 0) ? -(x) : (x))
#endif

/* Added from gregk's misc.h */
#ifndef SWAP
#define SWAP(a, b)  ({ typeof (a) _tmp = (a); (a) = (b); (b) = _tmp; })
#endif

#endif

#else

/* GCC allows new scopes inside expressions; use to get better MAX and MIN */

#define MAX(a, b)   ({ typeof (a) _a = (a); typeof (b) _b = (b); _a > _b ? _a : _b; })
#define MIN(a, b)   ({ typeof (a) _a = (a); typeof (b) _b = (b); _a < _b ? _a : _b; })
#define ABS(a)      ({ typeof (a) _a = (a); _a < (typeof (a)) 0 ? -_a : _a; })
#define SQUARE(x)   ({ typeof (x) _x = (x); _x*_x; })
#define SWAP(a, b)  ({ typeof (a) _tmp = (a); (a) = (b); (b) = _tmp; })
#define ROUND(a)    ({ typeof (a) __a = (a); (int) ((__a > 0) ? (__a + 0.5) : (__a - 0.5)); })
#define FLOAT_NAN     ({ float f; (*((long *) &f) = 0x7fffffff); f;})
#define DOUBLE_NAN    ({ double d; (*((long *) &d) = 0x7fffffff); (*(((long *) &d) + 1) = 0xffffffff); d;})


#endif

#define BOUND(x, l, h)   (MIN(MAX((x), (l)), (h)))

/* This is what malloc returns on error, and is also a null pointer */
#ifndef NULL
#define NULL    0
#endif

/*
 * Include common files. These come AFTER the defines above,
 * because mine are better.
 */
#include <stdio.h>
#ifndef SVR4
#include <stdlib.h>
#endif
#include <time.h>
#include <string.h>
#include <memory.h>
// #include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
// #include <sys/socket.h>
// #include <sys/time.h>
// #include <sys/ipc.h>
// #include <sys/shm.h>
// #include <sys/sem.h>
#include <float.h>
#include "panic.h"
#include "dbug.h"

/* Some library routines that never seem to get declared */

/* I don't feel like including setjmp.h, so this is commented out for now */
/*
ADT_LINKAGE  int _setjmp(jmp_buf env);
ADT_LINKAGE  volatile void _longjmp(jmp_buf env, int val);
*/

/* String functions: string[s].h doesn't have prototypes for all of them. */
/* Who needs prototypes? This breaks on SVR4 and I don't see why they 
 * should be here in the first place. Commented out until someone complains.
 * --mdw 
 */
/*
 * ADT_LINKAGE  int strcasecmp(char *s1, char *s2);
 * ADT_LINKAGE  int strncasecmp(char *s1, char *s2, int n);
 * ADT_LINKAGE  char *strdup(char *s);
 */


/* Sigh... index is a MACRO! */
/* 
 * ADT_LINKAGE  char *index(char *s, int c);
 */

/* Raw IO functions */
/* 
 * ADT_LINKAGE  int ioctl(int fd, unsigned int request, void *arg);
 * ADT_LINKAGE  int truncate(char *path, long length);
 * ADT_LINKAGE  int select(int width, fd_set *readfds, fd_set *writefds,
 *		  fd_set *exceptfds, struct timeval *timeout);
 * ADT_LINKAGE  int flock(int fd, int operation);
 * ADT_LINKAGE  caddr_t mmap(caddr_t addr, size_t len, int prot, int flags, int fd,
 *		    off_t off);
 * ADT_LINKAGE  int munmap(caddr_t addr, int len);
 */

/* Socket-fiddling functions */
// ADT_LINKAGE  int socket(int domaint, int type, int protocol);
// ADT_LINKAGE  int connect(int s, struct sockaddr *name, int namelen);
// ADT_LINKAGE  int bind(int s, struct sockaddr *name, int namelen);
// ADT_LINKAGE  int listen(int s, int backlog);
// ADT_LINKAGE  int accept(int s, struct sockaddr *addr, int *addrlen);

// #ifndef SVR4
/* Random stuff */
//  ADT_LINKAGE  long random(void);
// #endif
//  ADT_LINKAGE  void srandom(int seed);

// ADT_LINKAGE  double drand48();
// ADT_LINKAGE  long lrand48();
// ADT_LINKAGE  void srand48(long seedval);

/* Time stuff */

// char *strptime(char *buf, char *fmt, struct tm *tm);
// time_t timegm(struct tm *tm);
// time_t timelocal(struct tm *tm);
// void tzset(void);
// void tzsetwall(void);

#ifndef SVR4
/* Memory fiddling routines */
// ADT_LINKAGE  void bcopy(char *b1, char *b2, int length);
// ADT_LINKAGE  void bzero(char *b, int length);
#endif
 
/* Shared memory stuff */
/*
 * ADT_LINKAGE  int shmget(key_t key, int size, int shmflg);
 * ADT_LINKAGE  void *shmat(int shmid, void *shmaddr, int shmflg);
 * ADT_LINKAGE  int shmdt(void *shmaddr);
 * ADT_LINKAGE  int shmctl(int shmid, int cmd, struct shmid_ds *buf);
 */

/* Semaphore stuff */
/* ADT_LINKAGE  int semop(int semid, struct sembuf *sops, int nsops);
 * ADT_LINKAGE  int semget(key_t key, int nsems, int semflg);
 * ADT_LINKAGE  int semctl(int semid, int semnum, int cmd, union semun arg);
 */

/* and misc stuff */
/* ADT_LINKAGE  int getopt(int argc, char **argv, char *optstring);
 */
// ADT_LINKAGE  char *optarg;
// ADT_LINKAGE  int optind, opterr;
/* ADT_LINKAGE  void perror(const char *s);
 * ADT_LINKAGE  int gethostname(char *name, int namelen);
 * ADT_LINKAGE  int usleep(int time);
 */

/* 
 * ADT_LINKAGE  int fprintf(FILE *stream, const char *format, ...);
 * ADT_LINKAGE  int printf(const char *format, ...);
 * ADT_LINKAGE  int fscanf(FILE *stream, const char *format, ...);
 * ADT_LINKAGE  int sscanf(const char *s, const char *format, ...);
 * 
 * ADT_LINKAGE  int _filbuf();
 * ADT_LINKAGE  int _flsbuf();
 * ADT_LINKAGE  int fclose(FILE *stream);
 * ADT_LINKAGE  int fread(char *ptr, unsigned size, unsigned nitems, FILE *stream);
 * ADT_LINKAGE  int fwrite(const char *ptr, unsigned size, unsigned nitems, FILE *stream);
 * ADT_LINKAGE  int fflush(FILE *stream);
 * ADT_LINKAGE  int ungetc(int c, FILE *stream);
 */

#endif
