


#ifndef __INC_ADT_STRING
#define __INC_ADT_STRING

#include "./panic.h"
#include "./misc.h"
#include "./adtGlobals.h"


typedef struct {
  char *data;
  int mxlen;
} adtStringHeader;

typedef adtStringHeader *adtString;


#define ADT_NULLSTRING       ((adtString) NULL)



ADT_LINKAGE  adtString  strNew(int mxlen);
ADT_LINKAGE  void    strFree(adtString str);
ADT_LINKAGE  adtString  strClear(adtString str);
ADT_LINKAGE  adtString  strNewCopy(adtString str);
ADT_LINKAGE  adtString  strMake(char *s);
ADT_LINKAGE  int     strLen(adtString str);
ADT_LINKAGE  int     strCmp(adtString a, adtString b);
ADT_LINKAGE  int     strMaxLen(adtString str);
ADT_LINKAGE  char   *strGet(adtString str);
ADT_LINKAGE  char    strRef(adtString str, int i);


ADT_LINKAGE  adtString  strInit_(adtString *dest, char *s);
#define strInit(dest, s)          strInit_(&(dest), (s))
ADT_LINKAGE  adtString  strCopy_(adtString *dest, adtString src);
#define strCopy(dest, src)        strCopy_(&(dest), (src))
ADT_LINKAGE  adtString  strCat_(adtString *dest, adtString src);
#define strCat(dest, src)         strCat_(&(dest), (src))
ADT_LINKAGE  adtString  strAddChar_(adtString *dest, char ch);
#define strAddChar(dest, ch)      strAddChar_(&(dest), (ch))
ADT_LINKAGE  int     strNewLen_(adtString *dest, int newlen);
#define strNewLen(dest, newlen)   strNewLen_(&(dest), (newl))



/* probably need strSubStr, strInsert, find-substring,
   strToInt, strToFloat, strPrintF (using vsprintf) ... */

#endif 
