#include <stdio.h>
#include <stdlib.h>

#include "maxflow/maxflow.h"

#define NODE_MIN 0

#define NODE_NUM 4

#define SOURCE (NODE_MIN + 0)
#define SINK   (NODE_MIN + 1)
#define NODE1  (NODE_MIN + 2)
#define NODE2  (NODE_MIN + 3)

void main()
{
	long flow;
	struct Graph *g;
	int *cut;
	int i;
	
	g = init_graph(SOURCE, SINK);

	add_edge(g, SOURCE, NODE1, 5);
	add_edge(g, SOURCE, NODE2, 1);
	add_edge(g, NODE1, SINK, 2);
	add_edge(g, NODE2, SINK, 4);
	add_edge(g, NODE1, NODE2, 2);

	cut = (int *) malloc(NODE_NUM * sizeof(int)) - NODE_MIN;

	flow = maxflow(g, cut);

	printf("Flow = %d\n", flow);
	printf("Cut:\n");
	for ( i=NODE_MIN; i<NODE_MIN+NODE_NUM; i++ )
	{
		printf("\t[node %d]\t%d\n", i, cut[i]);
	}
	free(cut + NODE_MIN);
}
