/* generator of hard maxflow problems */
/* 01/09/94 - Stanford Computer Science Department */
/* Boris Cherkassky - cher@theory.stanford.edu, on.cher@zib-berlin.de */
/* Andrew V. Goldberg - goldberg@cs.stanford.edu */

#include <stdio.h>
#include <stdlib.h>

#include "maxflow/maxflow.h"

void main
(
int argc,
char* argv[]
)
{

int n, i, d;
struct Graph *g;
long node_min, node_max;
long flow;
int *cut;

if ( argc < 2 ) goto usage;

n = atoi(argv[1]);

if ( n < 2 ) goto usage;

g = init_graph(1, 2);

/* first terrible graph */

for ( i = 0; i<n ; i++ )
   {
     add_edge(g, i+3, i+4, n-i+1);
     add_edge(g, i+3, n+4, 1);
   }

add_edge(g, n+3, 2*n+4, 1);
add_edge(g, n+3, n+4, 1);

for ( i = n+3; i <= 2*n+2; i ++ )
   add_edge(g, i+1, i+2, n+1);

/* second horrible graph */

d = 2*n+4;

for ( i = d; i<=2*n+d ; i++ )
     add_edge(g, i+1, i+2, n);

for ( i = 0; i < n; i ++ )
     add_edge(g, i+d+1, 2*n+2-i+d, 1);


/* edges from source and to sink */

add_edge(g, 1, 3, 1000000);
add_edge(g, 1, d+1, 1000000);
add_edge(g, d, 2, 1000000);
add_edge(g, 4*n+6, 2, 1000000);

node_min = g->node_min;
node_max = g->node_max;
cut = (int *) malloc( (node_max - node_min) * sizeof(int) ) - node_min;
flow = maxflow(g, cut);

printf("Flow = %d\n", flow);
printf("Cut:\n");
for ( i=node_min; i<node_max; i++ )
{
	printf("\t[node %d]\t%d\n", i, cut[i]);
}
free(cut + node_min);

exit(0);

 usage:

printf(" usage: ak n (n>1)\n");
}
