/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.scene;

import cs6620.material.Material;
import cs6620.primitive.Primitive;
import cs6620.primitive.Sphere;
import cs6620.scene.Camera;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Scene {
    private ArrayList compoundObjects = new ArrayList();
    private ArrayList primitives = new ArrayList();
    private ArrayList materials = new ArrayList();
    
    public void addMesh(Mesh inMesh) {
        compoundObjects.add(inMesh);
    }

    public void addSphere(Sphere inSphere) {
        primitives.add(inSphere);
    }

    public List getCompoundObjects() {
        return compoundObjects;
    }
    
    public void addMaterial(Material inMaterial) {
        materials.add(inMaterial);
    }
    
    public List getMaterials() {
        return materials;
    }
    
    public void convertCompoundObjectsToPrimitives() {
        for (Iterator i = compoundObjects.iterator(); i.hasNext();) {
            CompoundObject object = (CompoundObject)i.next();
            List p = object.getPrimitives();
            primitives.addAll(p);
        }
    }
    
    public List getPrimitives() {
        return primitives;
    }
    
    public List getPrimitiveEmitters() {
        ArrayList result = new ArrayList();
        for (Iterator i = primitives.iterator(); i.hasNext();) {
            Primitive p = (Primitive)i.next();
            Material m = p.getMaterial();
            if (m.isEmissive()) {
                result.add(p);
            }
        }
        return result;
    }
}
