/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.scene;

import cs6620.primitive.Triangle;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;

public class Mesh extends CompoundObject {
    private double [] vertices;
    private int [] triangles;
    
    public List getPrimitives() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < triangles.length; i += 3) {
            Vector3d v0 = new Vector3d(vertices[triangles[i+0]*3+0],vertices[triangles[i+0]*3+1],vertices[triangles[i+0]*3+2]);
            Vector3d v1 = new Vector3d(vertices[triangles[i+1]*3+0],vertices[triangles[i+1]*3+1],vertices[triangles[i+1]*3+2]);
            Vector3d v2 = new Vector3d(vertices[triangles[i+2]*3+0],vertices[triangles[i+2]*3+1],vertices[triangles[i+2]*3+2]);
            Triangle t = new Triangle(v0,v1,v2);
            t.setMaterial(material);
            result.add(t);
        }
        return result;
    }    
    
    public void setVertices(double [] inVertices) {
        // assert (inVertices.length % 3 != 0); 
	// Must have a multiple of 3 coordinates
        vertices = inVertices;
    }
     
    public void setTriangles(int [] inTriangles) {
        // assert (inTriangles.length % 3 != 0); 
	// Must have a multiple of 3 vertices
        triangles = inTriangles;
    }
}
