/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.primitive;

import cs6620.geometry.IntersectionRecord;
import cs6620.geometry.Ray;
import cs6620.material.Material;

/** This class defines the abstract class Primitive.
 * Specific primitive such as triangle, rectangle, sphere etc.,
 * extend this class.
 */
public abstract class Primitive {
  protected Material material;

  /** returns the material of the primitive
   * @return the material assigned to this primitive
   */
  public Material getMaterial() {
    return material;
  }
  
  /** sets the material for the primitive
   * @param inMaterial the material to be assigned to this primtiive
   */
  public void setMaterial(Material inMaterial) {
    material = inMaterial;
  }

  public abstract boolean intersects(Ray inRay, IntersectionRecord outRecord);
  
}


