/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

import cs6620.material.RGBColor;
import javax.vecmath.Vector3d;

/**
 * A Ward material, as specified in the Computer Graphics 1992 paper
 * "Measuring and Modeling Anisotropic Reflection"
 */
public class Ward extends Material {
    private RGBColor specularColor;
    private RGBColor diffuseColor;
    private double rhod;
    private double rhos;
    private double alpha;
    

    public Ward () {
        diffuseColor = new RGBColor(0,0,0);
        specularColor = new RGBColor(0,0,0);
    }
    
    public void evaluateBRDF(Vector3d incidentDirection, Vector3d exitantDirection, RGBColor outValue) {
    }
    
    public void evaluateEmission(Vector3d exitantDirection, RGBColor outValue) {
        outValue.set(0,0,0);
    }
    
    public boolean isEmissive() {
        return false;
    }
    
    /** Getter for property specularColor.
     * @return Value of property specularColor.
     *
     */
    public RGBColor getSpecularColor() {
        return specularColor;
    }
    
    /** Setter for property specularColor.
     * @param m New value of property specularColor.
     *
     */
    public void setSpecularColor(RGBColor in) {
        specularColor.set(in);
    }
     
    /** Getter for property diffuseColor.
     * @return Value of property diffuseColor.
     *
     */
    public RGBColor getDiffuseColor() {
        return diffuseColor;
    }
    
    /** Setter for property diffuseColor.
     * @param m New value of property diffuseColor.
     *
     */
    public void setDiffuseColor(RGBColor inDiffuseColor) {
        diffuseColor.set(inDiffuseColor);
    }
    
    /** Getter for property alpha.
     * @return Value of property alpha.
     *
     */
    public double getAlpha() {
        return alpha;
    }
    
    /** Setter for property alpha.
     * @param n New value of property alpha.
     *
     */
    public void setAlpha(double inAlpha) {
        this.alpha = inAlpha;
    }

    /** Getter for property rhod.
     * @return Value of property rhod.
     *
     */
    public double getRhod() {
        return rhod;
    }
    
    /** Setter for property rhod.
     * @param n New value of property rhod.
     *
     */
    public void setRhod(double in) {
        this.rhod = in;
    }

    /** Getter for property rhos.
     * @return Value of property rhos.
     *
     */
    public double getRhos() {
        return rhos;
    }
    
    /** Setter for property rhos.
     * @param n New value of property rhos.
     *
     */
    public void setRhos(double in) {
        this.rhos = in;
    }
              
}
