/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */
 

package cs6620.material;

import javax.vecmath.Vector3d;

/** Use to represent radiometric quantities in 3 separate spectral wavelengths: red,
 * green, and blue. The exact wavelengths represented by these channels is not
 * specified. This class extends Vector3d, so all methods in that class can
 * be used.
 */
public class RGBColor extends Vector3d {

    public RGBColor(double r, double g, double b) {
        super(r,g,b);
    }
    
    public RGBColor() {
        super();
    }
    
    public RGBColor(RGBColor inColor) {
        super(inColor);
    }
    
    public double getR() {
        return x;
    }

    public double getG() {
        return y;
    }
    
    public double getB() {
        return z;
    }
    
    public void setR(double inValue) {
        x = inValue;
    }
    
    public void setG(double inValue) {
        y = inValue;
    }
    
    public void setB(double inValue) {
        z = inValue;
    }
}
