/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

import cs6620.material.RGBColor;
import javax.vecmath.Vector3d;

/**
 * A Phong material
 */
public class Phong extends Material {
    private RGBColor specularColor;
    private RGBColor diffuseColor;
    private double rhod;
    private double rhos;
    private double n;
    

    public Phong () {
        diffuseColor = new RGBColor(0,0,0);
        specularColor = new RGBColor(0,0,0);
    }
    
    public void evaluateBRDF(Vector3d incidentDirection, Vector3d exitantDirection, RGBColor outValue) {
    }
    
    public void evaluateEmission(Vector3d exitantDirection, RGBColor outValue) {
        outValue.set(0,0,0);
    }
    
    public boolean isEmissive() {
        return false;
    }
    
    /** Getter for property specularColor.
     * @return Value of property specularColor.
     *
     */
    public RGBColor getSpecularColor() {
        return specularColor;
    }
    
    /** Setter for property specularColor.
     * @param m New value of property specularColor.
     *
     */
    public void setSpecularColor(RGBColor in) {
        specularColor.set(in);
    }
     
    /** Getter for property diffuseColor.
     * @return Value of property diffuseColor.
     *
     */
    public RGBColor getDiffuseColor() {
        return diffuseColor;
    }
    
    /** Setter for property diffuseColor.
     * @param m New value of property diffuseColor.
     *
     */
    public void setDiffuseColor(RGBColor inDiffuseColor) {
        diffuseColor.set(inDiffuseColor);
    }
    
    /** Getter for property n.
     * @return Value of property n.
     *
     */
    public double getN() {
        return n;
    }
    
    /** Setter for property n.
     * @param n New value of property n.
     *
     */
    public void setN(double inN) {
        this.n = inN;
    }

    /** Getter for property rhod.
     * @return Value of property rhod.
     *
     */
    public double getRhod() {
        return rhod;
    }
    
    /** Setter for property rhod.
     * @param n New value of property rhod.
     *
     */
    public void setRhod(double in) {
        this.rhod = in;
    }

    /** Getter for property rhos.
     * @return Value of property rhos.
     *
     */
    public double getRhos() {
        return rhos;
    }
    
    /** Setter for property rhos.
     * @param n New value of property rhos.
     *
     */
    public void setRhos(double in) {
        this.rhos = in;
    }
              
}
