/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

import cs6620.material.RGBColor;
import javax.vecmath.Vector3d;

/** A representation of materials on the surface of geometric primitives. This
 * class allows you to query the BRDF and emissive properties of the material.
 */
public abstract class Material {
    /** Evaluates the BRDF of this material
     * @param incidentDirection the incident direction. This vector should be normalized and be in local
     * coordinates (with (0,0,1) pointing along the normal to the surface). This
     * vector should also point AWAY from the surface.
     * @param exitantDirection the exitant direction. This vector should be normalized and be in local
     * coordinates (with (0,0,1) pointing along the normal to the surface). This
     * vector should, like the incidentDirection, also point AWAY from the surface.
     * @param outValue the resulting BRDF value
     */    
    public abstract void evaluateBRDF(Vector3d incidentDirection, Vector3d exitantDirection, RGBColor outValue);
    /** Evaluates the radiance coming out of this material.
     * @param exitantDirection the exitant direction. This vector should be normalized and be in local
     * coordinates (with (0,0,1) pointing along the normal to the surface). This
     * vector should also point AWAY from the surface.
     * @param outValue the radiance along the exitant direction
     */    
    public abstract void evaluateEmission(Vector3d exitantDirection, RGBColor outValue);
    /** Is this material emissive? This method will return true if there is some
     * exitant direction for which the emission is not zero.
     * @return true if the material is emissive
     */    
    public abstract boolean isEmissive();
}
